return function(lvera)

    local screen = love.graphics.newCanvas()
    lvera:add_port({"@set resolution"}, function(counters)
        love.window.setMode(counters["@resolution x"], counters["@resolution y"])
        screen = resize(old_screen)
        counters["@resolution x"] = 0
        counters["@resolution y"] = 0
        counters["@set resolution"] = 0
    end)

    local point = {{0, 0, 0, 0, 0, 1}}
    lvera:add_port({"@set pixel"}, function(counters)
        point[1][1] = counters["@pixel x"]
        point[1][2] = counters["@pixel y"]
        point[1][3] = (counters["@pixel r"] % 256) / 255
        point[1][4] = (counters["@pixel g"] % 256) / 255
        point[1][5] = (counters["@pixel b"] % 256) / 255
        love.graphics.setCanvas(screen)
        love.graphics.points(point)
        love.graphics.setCanvas()
        counters["@pixel x"] = 0
        counters["@pixel y"] = 0
        counters["@pixel r"] = 0
        counters["@pixel g"] = 0
        counters["@pixel b"] = 0
        counters["@set pixel"] = 0
    end)

    lvera:add_port({"@draw line"}, function(counters)
        local old_r, old_g, old_b, old_a = love.graphics.getColor()
        local r, g, b = (counters["@pixel r"] % 256) / 255, (counters["@pixel g"] % 256) / 255, (counters["@pixel b"] % 256) / 255
        love.graphics.setCanvas(screen)
        love.graphics.setColor(r, g, b)
        love.graphics.setLineWidth(3)
        love.graphics.line(counters["@line x1"], counters["@line y1"], counters["@line x2"], counters["@line y2"])
        love.graphics.setColor(old_r, old_g, old_b, old_a)
        love.graphics.setCanvas()
        counters["@draw line"] = 0
        counters["@pixel r"] = 0
        counters["@pixel g"] = 0
        counters["@pixel b"] = 0
        counters["@line x1"] = 0
        counters["@line y1"] = 0
        counters["@line x2"] = 0
        counters["@line y2"] = 0
        counters["@line-width"] = 0
    end)

    lvera:add_port({"@display"}, function(counters)
        love.graphics.origin()
        love.graphics.clear(love.graphics.getBackgroundColor())
        love.graphics.draw(screen, 0, 0)
        love.graphics.present()
        counters["@display"] = 0
    end)
end