return function(lvera)
    local screen = love.graphics.newCanvas()
    function lvera.set_resolution(counters, resolution_x, resolution_y)
        love.window.setMode(resolution_x, resolution_y)
        screen = resize(old_screen)
    end

    local point = {{0, 0, 0, 0, 0, 1}}
    function lvera.set_pixel(counters, pixel_x, pixel_y, pixel_r, pixel_g, pixel_b)
        point[1][1] = pixel_x
        point[1][2] = pixel_y
        point[1][3] = (pixel_r % 256) / 255
        point[1][4] = (pixel_g % 256) / 255
        point[1][5] = (pixel_b % 256) / 255
        love.graphics.setCanvas(screen)
        love.graphics.points(point)
        love.graphics.setCanvas()
    end

    function lvera.draw_line(counters, line_x1, line_y1, line_x2, line_y2, pixel_r, pixel_g, pixel_b)
        local old_r, old_g, old_b, old_a = love.graphics.getColor()
        local r, g, b = (pixel_r % 256) / 255, (pixel_g % 256) / 255, (pixel_b % 256) / 255
        love.graphics.setCanvas(screen)
        love.graphics.setColor(r, g, b)
        love.graphics.setLineWidth(3)
        love.graphics.line(line_x1, line_y1, line_x2, line_y2)
        love.graphics.setColor(old_r, old_g, old_b, old_a)
        love.graphics.setCanvas()
    end


    function lvera.display(counters)
        love.graphics.origin()
        love.graphics.clear(love.graphics.getBackgroundColor())
        love.graphics.draw(screen, 0, 0)
        love.graphics.present()
    end
end