local Deque = require "deque"

local QueueMap = {}
QueueMap.__mt = {}

function QueueMap.new()
    local obj = {
        queues = {}
    }
    print(QueueMap.__mt.enqueue)
    return setmetatable(obj, {__index = QueueMap.__mt})
end

function QueueMap.__mt:peek(where)
    if self.queues[where] then
        return self.queues[where]:left()
    end
end


function QueueMap.__mt:poll(where)
    if self.queues[where] then
        self.queues[where]:pop_left()
    end
end

function QueueMap.__mt:enqueue(where, what)
    if not self.queues[where] then
        self.queues[where] = Deque.new()
    end
    self.queues[where]:push_right(what)
end


return QueueMap