local min, max, huge = math.min, math.max, math.huge
local machine = {state = {}}

machine.counters = {
	["run main loop"] = 1,
	["show message"] = 0,
	["@step timer"] = 0,
	["present current frame"] = 0,
	["sleep for 1ms"] = 0,
	["run current frame"] = 0,
	["@clear screen"] = 0,
	["@exit code"] = 0,
	["@present"] = 0,
	["@sleep"] = 0,
	["@ms"] = 0,
	["@print hello from vera"] = 0,
	["@poll inputs"] = 0,
	["next cycle"] = 0,
	["poll inputs"] = 0,
	["@quit love"] = 0,
	["@quit"] = 0,
	["step timer"] = 0,
	["clear the screen"] = 0,
}

machine.state = {
}

function machine:on_poll_inputs(counters)
end

function machine:on_quit_love(counters)
end

function machine:on_step_timer(counters)
end

function machine:on_clear_screen(counters)
end

function machine:on_present(counters)
end

function machine:on_sleep(counters, sleep)
end

function machine:on_hello_from_vera(counters)
end

function match(self, counters)
	if counters["@poll inputs"] > 0 then
		self:on_poll_inputs(counters)
		counters["@poll inputs"] = 0
		return true
	end
	if counters["@quit love"] > 0 then
		counters["@exit code"] = 0
		self:on_quit_love(counters)
		counters["@quit love"] = 0
		return true
	end
	if counters["@step timer"] > 0 then
		self:on_step_timer(counters)
		counters["@step timer"] = 0
		return true
	end
	if counters["@clear screen"] > 0 then
		self:on_clear_screen(counters)
		counters["@clear screen"] = 0
		return true
	end
	if counters["@present"] > 0 then
		self:on_present(counters)
		counters["@present"] = 0
		return true
	end
	if counters["@sleep"] > 0 then
		self:on_sleep(counters, counters["@sleep"])
		counters["@sleep"] = 0
		counters["@sleep"] = 0
		return true
	end
	if counters["@print hello from vera"] > 0 then
		self:on_hello_from_vera(counters)
		counters["@print hello from vera"] = 0
		return true
	end
	if counters["run main loop"] > 0 then
		local acc = counters["run main loop"]
		counters["run main loop"] = max(counters["run main loop"] - acc, 0)
		counters["poll inputs"] = counters["poll inputs"] + acc * 1
		counters["run current frame"] = counters["run current frame"] + acc * 1
		return true
	end
	if counters["poll inputs"] > 0 then
		local acc = counters["poll inputs"]
		counters["poll inputs"] = max(counters["poll inputs"] - acc, 0)
		counters["@poll inputs"] = counters["@poll inputs"] + acc * 1
		return true
	end
	if counters["run current frame"] > 0 and counters["@quit"] > 0 then
		local acc = huge
		acc = min(acc, counters["run current frame"])
		acc = min(acc, counters["@quit"])
		counters["run current frame"] = max(counters["run current frame"] - acc, 0)
		counters["@quit"] = max(counters["@quit"] - acc, 0)
		counters["@quit love"] = counters["@quit love"] + acc * 1
		return true
	end
	if counters["run current frame"] > 0 then
		local acc = counters["run current frame"]
		counters["run current frame"] = max(counters["run current frame"] - acc, 0)
		counters["show message"] = counters["show message"] + acc * 1
		counters["present current frame"] = counters["present current frame"] + acc * 1
		counters["sleep for 1ms"] = counters["sleep for 1ms"] + acc * 1
		counters["next cycle"] = counters["next cycle"] + acc * 1
		counters["step timer"] = counters["step timer"] + acc * 1
		counters["clear the screen"] = counters["clear the screen"] + acc * 1
		return true
	end
	if counters["step timer"] > 0 then
		local acc = counters["step timer"]
		counters["step timer"] = max(counters["step timer"] - acc, 0)
		counters["@step timer"] = counters["@step timer"] + acc * 1
		return true
	end
	if counters["clear the screen"] > 0 then
		local acc = counters["clear the screen"]
		counters["clear the screen"] = max(counters["clear the screen"] - acc, 0)
		counters["@clear screen"] = counters["@clear screen"] + acc * 1
		return true
	end
	if counters["show message"] > 0 then
		local acc = counters["show message"]
		counters["show message"] = max(counters["show message"] - acc, 0)
		counters["@print hello from vera"] = counters["@print hello from vera"] + acc * 1
		return true
	end
	if counters["present current frame"] > 0 then
		local acc = counters["present current frame"]
		counters["present current frame"] = max(counters["present current frame"] - acc, 0)
		counters["@present"] = counters["@present"] + acc * 1
		return true
	end
	if counters["sleep for 1ms"] > 0 then
		local acc = counters["sleep for 1ms"]
		counters["sleep for 1ms"] = max(counters["sleep for 1ms"] - acc, 0)
		counters["@ms"] = counters["@ms"] + acc * 1
		return true
	end
	if counters["next cycle"] > 0 then
		local acc = counters["next cycle"]
		counters["next cycle"] = max(counters["next cycle"] - acc, 0)
		counters["run main loop"] = counters["run main loop"] + acc * 1
		return true
	end
	return false
end

function machine:run()
    local counters = self.counters
    while match(self, counters) do end
end

return machine