# warning-ignore-all:return_value_discarded
extends HBoxContainer
class_name ChitinousCanrival

const event_player_scene = preload("res://scenes/ui/EventPlayer.tscn")

@onready var MinigameHandler      := %MinigameHandler      as MinigameHandler
@onready var TravelButtons        := %TravelButtons        as TravelButtons
@onready var EventPlayerContainer := %EventPlayerContainer as EventPlayerContainer
@onready var InventoryMenu        := %InventoryMenu        as InventoryMenu
@onready var SettingsMenu         := %SettingsMenu         as SettingsMenu
@onready var SaveMenu             := %SaveMenu             as SaveMenu
@onready var ChoicePanel          := %ChoicePanel          as Choice
@onready var StatusPanel          := %StatusPanel          as StatusPanel
@onready var Blackout             := %BlackoutPanel        as BlackoutPanel

var _current_sequence: String = ""

func _ready() -> void:
	randomize()

	MusicState.change_bg(MusicState.BACKGROUND_THEME)

	ExploreState.set_start_time()
	ExploreState._set_location(SimpleState.state.explore.location)
	TravelButtons.set_button_disabled(SimpleState.state.explore.location)

	SaveState.save_loaded.connect(_on_save_loaded)
	EventPlayerContainer.minigame_started.connect(_on_minigame_started)
	MinigameHandler.minigame_finished.connect(_on_minigame_finished)

	StatusPanel.inventory_button_toggled.connect(_on_inventory_button_toggled)
	StatusPanel.settings_button_toggled.connect(_on_settings_button_toggled)
	StatusPanel.save_button_toggled.connect(_on_save_button_toggled)

	InventoryMenu.visibility_changed.connect(_on_menu_visibility_changed)

	SaveMenu.visibility_changed.connect(_on_menu_visibility_changed)
	SaveMenu.closed.connect(StatusPanel.saving_closed)

	SettingsMenu.visibility_changed.connect(_on_menu_visibility_changed)
	SettingsMenu.closed.connect(StatusPanel.settings_closed)

	TravelButtons.waited.connect(_on_wait_button_pressed)

	ChoicePanel.options_shown.connect(_on_options_shown)
	ChoicePanel.options_cleared.connect(_on_options_cleared)

	ExploreState.trap_triggered.connect(_on_trap_triggered)
	ExploreState.event_triggered.connect(_on_event_triggered)
	ExploreState.event_trigger_forced.connect(_on_event_trigger_forced)
	ExploreState.revisited.connect(_on_revisited)
	ExploreState.wandered.connect(_on_wandered)
	ExploreState.item_selected.connect(_on_item_selected)
	ExploreState.masturbated.connect(_on_masturbated)

	if not MemoryState.has_seen("00-intro/00-premise"):
		InventoryState.add_trap("intro")
		EventPlayerContainer.run("00-intro/00-premise")

	if not SimpleState.state.sequence.current_sequence != "None":
		EventPlayerContainer.restore_from_state()

	await Blackout.fade_in()


func _on_revisited(event: String) -> void:
	EventPlayerContainer.run(event)


func _on_wandered(where: String) -> void:
	EventPlayerContainer.run("01-location/%s/wander" % where)


func _on_item_selected(what: String) -> void:
	StatusPanel.inventory_closed()
	EventPlayerContainer.run("items/%s" % what)

func _on_save_loaded(title) -> void:
	if not title:
		await Blackout.fade_out()

	EventPlayerContainer.hard_stop()
	ChoicePanel.clear_options()

	if SimpleState.state.sequence.current_sequence != "NONE":
		EventPlayerContainer.restore_from_state()
	else:
		EventPlayerContainer.hide()

	await Blackout.fade_in()


func _on_minigame_started(minigame: String, initial_state: Dictionary) -> void:
	MinigameHandler.play_minigame(minigame, initial_state)


func _on_minigame_finished(result) -> void:
	EventPlayerContainer.minigame_finished(result)


func _on_inventory_button_toggled(pressed: bool) -> void:

	InventoryMenu.visible = pressed

	if pressed:
		SettingsMenu.visible = false
		StatusPanel.settings_closed()

		SaveMenu.visible = false
		StatusPanel.saving_closed()


func _on_settings_button_toggled(pressed: bool) -> void:
	SettingsMenu.visible = pressed

	if pressed:
		InventoryMenu.visible = false
		StatusPanel.inventory_closed()

		SaveMenu.visible = false
		StatusPanel.saving_closed()


func _on_save_button_toggled(pressed: bool) -> void:
	SaveMenu.visible = pressed

	if pressed:
		InventoryMenu.visible = false
		StatusPanel.inventory_closed()

		SettingsMenu.visible = false
		StatusPanel.settings_closed()


func _on_menu_visibility_changed() -> void:
	EventPlayerContainer.set_input_disabled(any_menu_open())
	ChoicePanel.visible = !any_menu_open() and ChoicePanel.active


func _on_wait_button_pressed() -> void:
	await Blackout.fade_out()
	ExploreState.wait()
	await Blackout.fade_in()


func _on_options_shown() -> void:
	ChoicePanel.visible = !any_menu_open() and ChoicePanel.active


func _on_options_cleared() -> void:
	ChoicePanel.hide()
	await get_tree().process_frame


func _on_trap_triggered(_trap_name: String, event: String) -> void:
	EventPlayerContainer.run(event)


func _on_event_triggered(event, entry: String = "intro") -> void:
	EventPlayerContainer.run(event, entry)


func _on_event_trigger_forced(event, entry: String) -> void:
	if event == "NONE":
		EventPlayerContainer._on_scene_ended()
		ChoicePanel.clear_options()
	else:
		EventPlayerContainer._on_sequence_changed(event, entry)


func _on_masturbated() -> void:
	EventPlayerContainer.run("masturbations/init")


func any_menu_open() -> bool:
	return InventoryMenu.visible   \
		or SettingsMenu.visible    \
		or SaveMenu.visible
