extends Node

@export var character_layer_path : NodePath
@export var msg_listener_name = "character_handler"

@onready var character_layer: CanvasLayer = get_node(character_layer_path)

var _characters = {}
var _last_character := ""

func enter(who: String, modifiers: Dictionary = {}) -> void:
	if modifiers.has("facing") : match modifiers.facing:
		"left"  : modifiers.facing = Character.FACING_LEFT
		"right" : modifiers.facing = Character.FACING_RIGHT
	else:
		modifiers.facing = Character.FACING_RIGHT

	if modifiers.has("standing") : match modifiers.standing:
		"left"  : modifiers.standing = Character.STANDING_LEFT
		"center": modifiers.standing = Character.STANDING_CENTER
		"right" : modifiers.standing = Character.STANDING_RIGHT
	else:
		modifiers.standing = Character.STANDING_LEFT

	if not modifiers.has("current_emote"): modifiers.current_emote = "default"

	if not who in _characters:
		_characters[who] = Characters.items[who].instantiate()
		character_layer.add_child(_characters[who])


	for modifier in modifiers:
		_characters[who][modifier] = modifiers[modifier]

	_last_character = who

	SimpleState.update_deep("sequence",
		{ characters = { who: modifiers } }
	)


func face(face: String, character: String = _last_character) -> void:
	assert(face in ["left", "right"]
		, "Invalid position %s. Must be 'left' or 'right" % face)
	SimpleState.update_deep("sequence",
		{ characters = { character: { facing = face } } }
	)
	if character != _last_character: _last_character = character

	var facing: int = Character.STANDING_LEFT
	match face:
		"left"  : facing = Character.FACING_LEFT
		"right" : facing = Character.FACING_RIGHT

	update(character, "facing", facing)


func stand(stand: String, character: String = _last_character) -> void:
	assert(stand in ["left", "center", "right"]
		, "Invalid position %s. Must be 'left' or 'center' or 'right" % stand)

	SimpleState.update_deep("sequence",
		{ characters = { character: { standing = stand } } }
	)
	if character != _last_character: _last_character = character

	var standing: int = Character.STANDING_LEFT
	match stand:
		"left"  : standing = Character.STANDING_LEFT
		"center": standing = Character.STANDING_CENTER
		"right" : standing = Character.STANDING_RIGHT

	update(character, "standing", standing)


func emote(emote: String, character: String = _last_character) -> void:
	SimpleState.update_deep("sequence",
		{ characters = { character: { current_emote = emote } } }
	)
	if character != _last_character: _last_character = character

	update(character, "current_emote", emote)


func update(who: String, what: String, with) -> void:
	_characters[who][what] = with
	_last_character = who

func leave(who: String) -> void:
	var characters: Dictionary = SimpleState.state.sequence.characters.duplicate()
	characters.erase(who) # warning-ignore:return_value_discarded
	SimpleState.update("sequence",
		{ characters = characters }
	)

	if who in _characters:
		character_layer.remove_child(_characters[who])
		_characters[who].queue_free()
		_characters.erase(who)


func everyone_leave() -> void:
	for who in _characters:
		character_layer.remove_child(_characters[who])
