extends Node
class_name Playback

signal line_changed(line : String)
signal dialogue_shown(dialogue : DialogueLine)
signal options_shown(options : Array[String])
signal dialogue_cleared
signal scene_finished

signal options_picked(line_id : String)
signal dialogue_finished	   # warning-ignore:unused_signal

var dialogue_line : DialogueLine
var extra_game_states : Array

func run(script : DialogueResource, entry: String = "intro", _restore : bool = false) -> void:
	dialogue_line = await DialogueManager.get_next_dialogue_line(script, entry, extra_game_states)

	line_changed.emit(entry)
	while dialogue_line:
		var next_id = dialogue_line.next_id

		if not dialogue_line.text.is_empty():
			dialogue_shown.emit(dialogue_line)
			await self.dialogue_finished

		if len(dialogue_line.responses) > 0:
			var options : Array[String] = []

			for response in dialogue_line.responses:
				options.append(response.text)
				options.append(response.next_id)

			options_shown.emit(options)
			next_id = await self.options_picked

		else:
			var default : Array[String] = [">> Next", ""]
			options_shown.emit(default)
			await self.options_picked

		dialogue_cleared.emit()
		line_changed.emit(next_id)
		dialogue_line = await DialogueManager.get_next_dialogue_line(script, next_id, extra_game_states)

	scene_finished.emit()
