extends Node
class_name Choice
const ButtonBase = preload("res://scenes/ui/misc/ButtonBase.tscn")

signal options_shown()
signal options_cleared()
signal option_picked(index, line_id)

@export var option_path : NodePath
@export var msg_listener_name = "option_presenter"

var active := false

@onready var options: VBoxContainer = get_node(option_path)


func show_options(option_list: Array) -> void:
	assert(len(option_list) % 2 == 0, "Options must be multiples of 2")

	var count = min(6, len(option_list))
	var buttons = []
	for i in range(0, count, 2):
		buttons.append(_add_option(option_list[i], option_list[i + 1]))

	(buttons[0] as Button).grab_focus()
	for i in range(1, len(buttons)):
		var top: Button = buttons[i - 1]
		var bottom: Button = buttons[i]
		bottom.focus_neighbor_top = top.get_path()
		top.focus_neighbor_bottom = bottom.get_path()

	active = true
	emit_signal("options_shown")


func clear_options() -> void:
	for child in options.get_children():
		options.remove_child(child)
		child.queue_free()

	active = false
	emit_signal("options_cleared")


func _add_option(text: String, line_id: String) -> Button:
	var button = ButtonBase.instantiate()
	button.focus_mode = Control.FOCUS_ALL
	button.text = text
	button.connect("pressed", Callable(self, "_on_button_pressed").bind(options.get_child_count(), line_id))
	options.add_child(button)
	return button

func _on_button_pressed(index: int, line: String) -> void:
	clear_options()
	emit_signal("option_picked", index, line)
