package.path = package.path .. ";./src/?.lua"
local Lvera = require "lvera"
local lua_generator = require "generators.lua"

local lvera = Lvera.new()

lvera:load("samples/hailstone.nv")

lvera:add_pass(require "passes.ports" (lua_generator.ports))
lvera:add_pass(require "passes.constants")
lvera:add_pass(require "passes.eliminate-dead-code")

local compiled_lua = lvera:compile(lua_generator)

local out_file = io.open("generated.lua", "w+")
out_file:write(compiled_lua)

local machine = load(compiled_lua)()
function machine.on_print_number(_, number)
    print(number)
end

machine:run()