local min, max, huge = math.min, math.max, math.huge
local machine = {}

machine.counters = {
	["x:3"] = 0,
	["x:27"] = 1,
	["1"] = 0,
	["2"] = 0,
	["copy x to @number"] = 0,
	["print number"] = 0,
	["x -> @number:9007199254740991"] = 0,
	["move"] = 0,
	["temporary x"] = 0,
	["@print number"] = 0,
	["hailstone"] = 1,
	["x"] = 0,
	["odd"] = 0,
	["x:6"] = 0,
	["@number"] = 0,
	["x -> @number"] = 0,
	["eval"] = 0,
	["show x"] = 0,
}

function machine.on_print_number(counters, number)
end

function match(self, counters)
	if counters["@print number"] > 0 then
		self.on_print_number(counters, counters["@number"])
		counters["@print number"] = 0
		counters["@number"] = 0
		return true
	end
	if counters["x:27"] > 0 then
		acc = counters["x:27"]
		counters["x:27"] = max(counters["x:27"] - acc, 0)
		counters["x"] = counters["x"] + acc * 27
		return true
	end
	if counters["x:6"] > 0 then
		acc = counters["x:6"]
		counters["x:6"] = max(counters["x:6"] - acc, 0)
		counters["x"] = counters["x"] + acc * 6
		return true
	end
	if counters["x -> @number:9007199254740991"] > 0 then
		acc = counters["x -> @number:9007199254740991"]
		counters["x -> @number:9007199254740991"] = max(counters["x -> @number:9007199254740991"] - acc, 0)
		counters["x -> @number"] = counters["x -> @number"] + acc * 9007199254740991
		return true
	end
	if counters["x:3"] > 0 then
		acc = counters["x:3"]
		counters["x:3"] = max(counters["x:3"] - acc, 0)
		counters["x"] = counters["x"] + acc * 3
		return true
	end
	if counters["show x"] > 0 then
		acc = counters["show x"]
		counters["show x"] = max(counters["show x"] - acc, 0)
		counters["print number"] = counters["print number"] + acc * 1
		counters["copy x to @number"] = counters["copy x to @number"] + acc * 1
		return true
	end
	if counters["copy x to @number"] > 0 then
		acc = counters["copy x to @number"]
		counters["copy x to @number"] = max(counters["copy x to @number"] - acc, 0)
		counters["x -> @number:9007199254740991"] = counters["x -> @number:9007199254740991"] + acc * 1
		return true
	end
	if counters["x -> @number"] > 0 and counters["x"] > 0 then
		local acc = huge
		acc = min(acc, counters["x -> @number"])
		acc = min(acc, counters["x"])
		counters["x -> @number"] = max(counters["x -> @number"] - acc, 0)
		counters["x"] = max(counters["x"] - acc, 0)
		counters["@number"] = counters["@number"] + acc * 1
		counters["temporary x"] = counters["temporary x"] + acc * 1
		return true
	end
	if counters["x -> @number"] > 0 then
		acc = counters["x -> @number"]
		counters["x -> @number"] = max(counters["x -> @number"] - acc, 0)
		return true
	end
	if counters["temporary x"] > 0 then
		acc = counters["temporary x"]
		counters["temporary x"] = max(counters["temporary x"] - acc, 0)
		counters["x"] = counters["x"] + acc * 1
		return true
	end
	if counters["print number"] > 0 then
		acc = counters["print number"]
		counters["print number"] = max(counters["print number"] - acc, 0)
		counters["@print number"] = counters["@print number"] + acc * 1
		return true
	end
	if counters["move"] > 0 and counters["2"] > 0 then
		local acc = huge
		acc = min(acc, counters["move"])
		acc = min(acc, counters["2"])
		counters["move"] = max(counters["move"] - acc, 0)
		counters["2"] = max(counters["2"] - acc, 0)
		counters["move"] = counters["move"] + acc * 1
		counters["x"] = counters["x"] + acc * 1
		return true
	end
	if counters["move"] > 0 and counters["1"] > 0 then
		local acc = huge
		acc = min(acc, counters["move"])
		acc = min(acc, counters["1"])
		counters["move"] = max(counters["move"] - acc, 0)
		counters["1"] = max(counters["1"] - acc, 0)
		counters["x"] = counters["x"] + acc * 1
		return true
	end
	if counters["move"] > 0 then
		acc = counters["move"]
		counters["move"] = max(counters["move"] - acc, 0)
		counters["hailstone"] = counters["hailstone"] + acc * 1
		return true
	end
	if counters["odd"] > 0 and counters["2"] > 0 then
		local acc = huge
		acc = min(acc, counters["2"])
		acc = min(acc, counters["odd"])
		counters["odd"] = max(counters["odd"] - acc, 0)
		counters["2"] = max(counters["2"] - acc, 0)
		counters["x:6"] = counters["x:6"] + acc * 1
		counters["odd"] = counters["odd"] + acc * 1
		return true
	end
	if counters["odd"] > 0 then
		acc = counters["odd"]
		counters["odd"] = max(counters["odd"] - acc, 0)
		counters["x"] = counters["x"] + acc * 1
		counters["hailstone"] = counters["hailstone"] + acc * 1
		return true
	end
	if counters["eval"] > 0 and counters["x"] > 0 and counters["1"] > 0 then
		local acc = huge
		acc = min(acc, counters["1"])
		acc = min(acc, counters["eval"])
		acc = min(acc, counters["x"])
		counters["eval"] = max(counters["eval"] - acc, 0)
		counters["x"] = max(counters["x"] - acc, 0)
		counters["1"] = max(counters["1"] - acc, 0)
		counters["eval"] = counters["eval"] + acc * 1
		counters["2"] = counters["2"] + acc * 1
		return true
	end
	if counters["eval"] > 0 and counters["x"] > 0 then
		local acc = huge
		acc = min(acc, counters["eval"])
		acc = min(acc, counters["x"])
		counters["eval"] = max(counters["eval"] - acc, 0)
		counters["x"] = max(counters["x"] - acc, 0)
		counters["eval"] = counters["eval"] + acc * 1
		counters["1"] = counters["1"] + acc * 1
		return true
	end
	if counters["eval"] > 0 and counters["2"] > 0 and counters["1"] > 0 then
		local acc = huge
		acc = min(acc, counters["1"])
		acc = min(acc, counters["eval"])
		acc = min(acc, counters["2"])
		counters["eval"] = max(counters["eval"] - acc, 0)
		counters["2"] = max(counters["2"] - acc, 0)
		counters["1"] = max(counters["1"] - acc, 0)
		counters["x:3"] = counters["x:3"] + acc * 1
		counters["2"] = counters["2"] + acc * 1
		counters["odd"] = counters["odd"] + acc * 1
		return true
	end
	if counters["eval"] > 0 then
		acc = counters["eval"]
		counters["eval"] = max(counters["eval"] - acc, 0)
		counters["move"] = counters["move"] + acc * 1
		return true
	end
	if counters["hailstone"] > 0 then
		acc = counters["hailstone"]
		counters["hailstone"] = max(counters["hailstone"] - acc, 0)
		counters["show x"] = counters["show x"] + acc * 1
		counters["eval"] = counters["eval"] + acc * 1
		return true
	end
	return false
end

function machine:run()
    local counters = self.counters
    while match(self, counters) do end
end

return machine