using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.UI;


public class IntroStory : MonoBehaviour
{
    
    Dictionary<string, AudioClip> audioClips = new Dictionary<string, AudioClip>();
    Dictionary<string, Animator> animators = new Dictionary<string, Animator>();
    int index = 0;
    string[] sequence =
    {
        "intro-00",
        "intro-01",
        "intro-02",
        "intro-03",
        "intro-04",
        "intro-05",
        "intro-06",
        "intro-07",
        "intro-08",
        "intro-09",
        "intro-10",
        "intro-11",
        "intro-12",
        "intro-13",
        "intro-14",
        "intro-15",
        "intro-16"
    };
    [SerializeField]
    public Button button;

    [SerializeField]
    public StoryEngine engine;

    [SerializeField]
    public GameObject Erika;

    [SerializeField]
    public GameObject Alice;

    // Start is called before the first frame update
    void Start()
    {
        engine.LoudAudioClips("AudioClips/InstructionScene");
        engine.AddActor("Erika", Erika.GetComponent<Animator>());
        engine.AddActor("Alice", Alice.GetComponent<Animator>());

        engine.Register("intro-00", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_0");
            engine.PlayClip("intro-00");
        });

        engine.Register("intro-01", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_1");
            engine.PlayClip("intro-01");
        });

        engine.Register("intro-02", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_2");
            engine.PlayClip("intro-02");
        });

        engine.Register("intro-03", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_3");
            engine.PlayClip("intro-03");
        });

        engine.Register("intro-04", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_4");
            engine.SetActorTrigger("Alice", "Appear");
            engine.PlayClip("intro-04");
        });

        engine.Register("intro-05", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_5");
            engine.PlayClip("intro-05");
        });

        engine.Register("intro-06", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_6");
            engine.PlayClip("intro-06");
        });

        engine.Register("intro-07", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_7");
            engine.PlayClip("intro-07");
        });

        engine.Register("intro-08", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_8");
            engine.PlayClip("intro-08");
            engine.SetActorTrigger("Alice", "Disappear");
        });

        engine.Register("intro-09", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_9");
            engine.PlayClip("intro-09");
        });

        engine.Register("intro-10", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_10");
            engine.PlayClip("intro-10");
        });

        engine.Register("intro-11", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_11");
            engine.PlayClip("intro-11");
        });

        engine.Register("intro-12", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_12");
            engine.PlayClip("intro-12");
        });

        engine.Register("intro-13", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_13");
            engine.PlayClip("intro-13");
        });

        engine.Register("intro-14", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_14");
            engine.PlayClip("intro-14");
        });

        engine.Register("intro-15", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_15");
            engine.PlayClip("intro-15");
        });

        engine.Register("intro-16", (engine, args) =>
        {
            engine.SetActorTrigger("Erika", "isInst_16");
            engine.PlayClip("intro-16");
        });

        engine.Register("enable-button", (engine, args) =>
        {
            (args[0] as Button).interactable = true;
        });
        Debug.Log(engine);
    }

    // Update is called once per frame
    void Update()
    {
        
    }

    public void OnNextButtonPressed (Button button)
    {
        button.interactable = false;
        engine.Run(engine.GetClipLength(sequence[index]), "enable-button", button);
        engine.Run(sequence[index]);
        index += 1;
    }

}
