Cell := Object clone do (
    state := nil
    occupy := method(player,
        state = player
    )
    empty := method(state isNil)
    asString := method(
        if(state isNil, return "_")
        state
    )
)

Grid := Object clone do (
    init := method(
        self grid := list(
            list(Cell clone, Cell clone, Cell clone),
            list(Cell clone, Cell clone, Cell clone),
            list(Cell clone, Cell clone, Cell clone)
        )
    )

    init
    asString := method(
        grid map (row, " " .. row join(" | ")) join("\n---+---+---\n")
    )

    at := method(row, column, grid at(row) ?at(column))

    isInBounds := method(row, column, at(row, column) isNil not)

    isEmpty := method(row, column, at(row, column) empty)

    occupy := method(row, column, who, at(row, column) occupy(who))

    occupant := method(row, column, at(row, column) state)

    winnerInRow := method(row,
        if (occupant(row, 0) == occupant(row, 1) and occupant(row, 1) == occupant(row, 2)) \
        then(return occupant(row, 0))
    )

    winnerInColumn := method(col,
        if (occupant(0, col) == occupant(1, col) and occupant(1, col) == occupant(2, col)) \
        then(return occupant(0, col))
    )

    winnerDiagonal := method(
        if (occupant(0, 0) == occupant(1, 1) and occupant(1, 1) == occupant(2, 2)) \
        then (return occupant(0, 0))
        if (occupant(0, 2) == occupant(1, 1) and occupant(1, 1) == occupant(2, 0)) \
        then(return occupant(0, 2))
    )
    winner := method(
        if(winnerInRow(0), return winnerInRow(0))
        if(winnerInRow(1), return winnerInRow(1))
        if(winnerInRow(2), return winnerInRow(2))
        if(winnerInColumn(0), return winnerInColumn(0))
        if(winnerInColumn(1), return winnerInColumn(1))
        if(winnerInColumn(2), return winnerInColumn(2))
        if(winnerDiagonal, return winnerDiagonal)
    )
)

Game := Object clone do (
    init := method(
        self stdin := File standardInput
        self turn := "X"
        self turnsLeft := 9
        self state := "playing"
        self grid := Grid clone
    )

    init
    getWinner := method(
        if(grid winner, return grid winner)
        if(turnsLeft == 0, return "draw")
        nil
    )

    changeTurn := method(
        turnsLeft = turnsLeft - 1
        if(turn == "X") then(turn = "O") else(turn = "X")
    )

    takeTurn := method(
        loop(
            println
            "enter turn for " print ; turn print ; " > " print
            position := stdin readLine split map(asNumber)
            
            (position size == 2) ifFalse (
                "please enter two numbers seperated by spaces!" println
                continue
            )
            
            row := position at(0)
            column := position at(1)

            grid isInBounds(row, column) ifFalse (
                "space is out of bounds." println
                continue
            )

            grid isEmpty(row, column) ifFalse (
                "can't make move there." println
                continue
            )
            
            grid occupy(row, column, turn)
            break
        )
        changeTurn
    )

    play := method(
        while(turnsLeft > 0 and getWinner isNil, takeTurn)
        println
        if(getWinner) then(("The winner is " .. getWinner) println) else("It's a draw" println)

    )

    asString := method("Turn: " .. turn .. "\n" .. grid)
)