/**
Input program:
    mem(A,_), mem(A,_) <=> fail
    prog(L,_,_,_), prog(L,_,_,_) <=> fail
    pc(_), pc(_) <=> fail

    prog(L,"add",B,A), mem(B,Y) \ mem(A,X), pc(L) <=> mem(A,X+Y), pc(L+1)
    prog(L,"sub",B,A), mem(B,Y) \ mem(A,X), pc(L) <=> mem(A,X-Y), pc(L+1)
    prog(L,"mult",B,A), mem(B,Y) \ mem(A,X), pc(L) <=> mem(A,X*Y), pc(L+1)
    prog(L,"div",B,A), mem(B,Y) \ mem(A,X), pc(L) <=> mem(A,X/Y), pc(L+1)

    prog(L,"move",B,A), mem(B,X) \ mem(A,_), pc(L) <=> mem(A,X), pc(L+1)
    prog(L,"i_mov",B,A), mem(B,C), mem(C,X) \ mem(A,_), pc(L) <=> mem(A,X), pc(L+1)
    prog(L,"mov_i",B,A), mem(B,X), mem(A,C) \ mem(C,_), pc(L) <=> mem(C,X), pc(L+1)

    prog(L,"const",B,A) \ mem(A,_), pc(L) <=> mem(A,B), pc(L+1)
    prog(L,"init",A,_), mem(A,B) \ pc(L) <=> mem(B,0), pc(L+1)

    prog(L,"jump",_,A) \ pc(L) <=> pc(A)
    prog(L,"cjmp",R,A), mem(R,X) \ pc(L) <=> X == 0 | pc(A)
    prog(L,"cjmp",R,_), mem(R,X) \ pc(L) <=> X != 0 | pc(L+1)

    prog(L,"halt",_,_) \ pc(L) <=> true

    pc(_) <=> fail
 */

module.exports = (function () {

  /* eslint no-labels: ["error", { "allowLoop": true }] */
  
  // Constraint
  function Constraint (name, arity, args) {
    this.name = name
    this.arity = arity
    this.functor = name + '/' + arity
    this.args = args
    this.id = null
    this.alive = true
    this.activated = false
    this.stored = false
    this.hist = null
    this.cont = null
  }
  
  Constraint.prototype.continue = function () {
    this.cont[0].call(this, this, this.cont[1])
  }
  
  Constraint.prototype.toString = function () {
    let s = this.name
    if (this.arity >= 1) {
      s += '(' + this.args.join(',') + ')'
    }
    return s
  }
  
  // Store
  function Store () {
    this._index = {}
    this._size = 0
    this._nextId = 0
  }
  
  Store.prototype.add = function (constraint) {
    if (typeof this._index[constraint.functor] === 'undefined') {
      this._index[constraint.functor] = []
    }
    constraint.id = this._nextId
    this._index[constraint.functor].push(constraint)
    this._size += 1
    this._nextId += 1
  }
  
  Store.prototype.remove = function (constraint) {
    constraint.alive = false
    const ix = this._index[constraint.functor].indexOf(constraint)
    this._index[constraint.functor].splice(ix, 1)
  
    this._size -= 1
  }
  
  Store.prototype.lookup = function (rule, patterns, constraint) {
    const ret = this.lookupResume(rule, patterns, constraint, 0)
    if (!ret || !ret.res) {
      return false
    }
    return ret.res
  }
  
  Store.prototype.lookupResume = function (rule, patterns, constraint, startFrom) {
    startFrom = startFrom || 0
  
    const lastPattern = patterns.length - 1
    const lengths = []
    const divs = []
    let div = 1
    let i
  
    // build array of arrays
    const arr = []
    for (i = 0; i <= lastPattern; i++) {
      if (patterns[i] === '_') {
        // "_" is a placeholder for the given `constraint`
        arr[i] = [constraint]
      } else if (typeof this._index[patterns[i]] !== 'undefined') {
        arr[i] = this._index[patterns[i]]
      } else {
        // not a single element for this functor
        return false
      }
    }
  
    for (i = lastPattern; i >= 0; i--) {
      lengths[i] = arr[i].length
      divs[i] = div
      div *= arr[i].length
    }
    const max = divs[0] * arr[0].length
  
    let res
    let resIds
    let curr
    loopng: for (let n = startFrom; n < max; n++) {
      res = []
      resIds = []
      curr = n
      for (i = 0; i <= lastPattern; i++) {
        res[i] = arr[i][curr / divs[i] >> 0]
        resIds[i] = res[i].id
  
        // avoid multiple occurences of the same constraint
        if (res.slice(0, i).indexOf(res[i]) !== -1) {
          continue loopng
        }
  
        curr = curr % divs[i]
      }
  
      // check if already in history
      /*
      if (history.lookup(rule, resIds)) {
        continue loopng
      }
  */
      return {
        n: n,
        res: res
      }
    }
  
    return false
  }
  
  Store.prototype.size = function () {
    return this._size
  }
  
  Store.prototype.valueOf = function () {
    return this.size()
  }
  
  Store.prototype.toString = function () {
    if (this.size() === 0) {
      return '(empty)'
    }
  
    let maxLengthC = 'constraint'.length
    let maxLengthI = 'id'.length
    const rows = []
    let functor
    for (functor in this._index) {
      this._index[functor].forEach(function (c) {
        const s = c.toString()
        maxLengthC = Math.max(s.length, maxLengthC)
        maxLengthI = Math.max(c.id.toString().length + 1, maxLengthI)
      })
    }
    for (functor in this._index) {
      this._index[functor].forEach(function (c) {
        rows.push(c.id.toString().padStart(maxLengthI) + ' | ' + c.toString().padEnd(maxLengthC))
      })
    }
  
    return [
      'id'.padStart(maxLengthI) + ' | ' + 'constraint'.padEnd(maxLengthC),
      ''.padStart(maxLengthI, '-') + '-+-' + ''.padEnd(maxLengthC, '-')
    ].concat(rows).join('\n')
  }
  
  // History
  /*
  function History () {
    this._index = {}
    this._size = 0
  }
  
  History.prototype.size = function () {
    return this._size
  }
  
  History.prototype.valueOf = function () {
    return this.size()
  }
  
  History.prototype.toString = function () {
    if (this.size() === 0) {
      return "(empty)"
    }
  
    var maxLength_r = "rule".length
    var maxLength_f = "fired with".length
    var rows = []
    var curr
    for (var rule in this._index) {
      maxLength_r = Math.max(rule.toString().length, maxLength_r)
    }
  
    // TODO
  }
  
  History.prototype.add = function (rule, ids) {
    if (!this._index.hasOwnProperty(rule)) {
      this._index[rule] = {}
    }
  
    var curr = this._index[rule]
    for (var i = 0; i < ids.length-1; i++) {
      if (!curr.hasOwnProperty(ids[i])) {
        curr[ids[i]] = {}
      }
      curr = curr[ids[i]]
    }
    curr[ids[i]] = true
  
    this._size += 1
  }
  
  History.prototype.lookup = function (rule, ids) {
    if (!this._index.hasOwnProperty(rule)) {
      return false
    }
  
    var curr = this._index[rule]
    for (var i = 0; i < ids.length; i++) {
      if (!curr[ids[i]]) {
        return false
      }
      curr = curr[ids[i]]
    }
  
    if (curr !== true) {
      return false
    }
  
    return true
  }
  */
  // trampoline
  function trampoline () { // eslint-disable-line
    let constraint
    while (constraint = stack.pop()) { // eslint-disable-line
      constraint.continue()
    }
  }
  
  var chr = { // eslint-disable-line
    Store: new Store()
  }
  
  var stack = [] // eslint-disable-line
  // var history = new History()
  
  function __mem_2_0 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var __0 = constraint.args[1]

    var constraintPattern = [ "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(0, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_1, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var A = constraints[0].args[0]
    var _ = constraints[0].args[1]

    if (!(A === A_0 && _ === __0)) {
      constraint.cont = [__mem_2_0, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[0])

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_1 (constraint, __n) {
    __n = __n || 0

    var A = constraint.args[0]
    var _ = constraint.args[1]

    var constraintPattern = [ "_", "mem/2" ]
    var lookupResult = chr.Store.lookupResume(0, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_2, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var A_0 = constraints[1].args[0]
    var __0 = constraints[1].args[1]

    if (!(A === A_0 && _ === __0)) {
      constraint.cont = [__mem_2_1, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __prog_4_0 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]
    var __2 = constraint.args[1]
    var __3 = constraint.args[2]
    var __4 = constraint.args[3]

    var constraintPattern = [ "prog/4", "_" ]
    var lookupResult = chr.Store.lookupResume(1, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_1, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    var _ = constraints[0].args[1]
    var __0 = constraints[0].args[2]
    var __1 = constraints[0].args[3]

    if (!(_ === __0 && _ === __1 && L === L_0 && _ === __2 && _ === __3 && _ === __4)) {
      constraint.cont = [__prog_4_0, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[0])

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __prog_4_1 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    var _ = constraint.args[1]
    var __0 = constraint.args[2]
    var __1 = constraint.args[3]

    var constraintPattern = [ "_", "prog/4" ]
    var lookupResult = chr.Store.lookupResume(1, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_2, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L_0 = constraints[1].args[0]
    var __2 = constraints[1].args[1]
    var __3 = constraints[1].args[2]
    var __4 = constraints[1].args[3]

    if (!(_ === __0 && _ === __1 && L === L_0 && _ === __2 && _ === __3 && _ === __4)) {
      constraint.cont = [__prog_4_1, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __pc_1_0 (constraint, __n) {
    __n = __n || 0

    var __0 = constraint.args[0]

    var constraintPattern = [ "pc/1", "_" ]
    var lookupResult = chr.Store.lookupResume(2, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_1, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var _ = constraints[0].args[0]

    if (!(_ === __0)) {
      constraint.cont = [__pc_1_0, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[0])

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __pc_1_1 (constraint, __n) {
    __n = __n || 0

    var _ = constraint.args[0]

    var constraintPattern = [ "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(2, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_2, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var __0 = constraints[1].args[0]

    if (!(_ === __0)) {
      constraint.cont = [__pc_1_1, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __pc_1_2 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(3, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_3, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "add") {
      constraint.cont = [__pc_1_2, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_2, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X + Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_2 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(3, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_3, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "add") {
      constraint.cont = [__mem_2_2, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_2, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X + Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_3 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var Y = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(3, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_4, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "add") {
      constraint.cont = [__mem_2_3, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_3, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X + Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_3, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_2 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "add") {
      constraint.cont = [__prog_4_3, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(3, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_3, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_2, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X + Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_2, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_3 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(4, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_4, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "sub") {
      constraint.cont = [__pc_1_3, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_3, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X - Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_4 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(4, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_5, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "sub") {
      constraint.cont = [__mem_2_4, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_4, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X - Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_5 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var Y = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(4, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_6, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "sub") {
      constraint.cont = [__mem_2_5, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_5, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X - Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_5, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_3 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "sub") {
      constraint.cont = [__prog_4_4, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(4, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_4, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_3, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X - Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_3, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_4 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(5, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_5, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mult") {
      constraint.cont = [__pc_1_4, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_4, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X * Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_6 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(5, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_7, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mult") {
      constraint.cont = [__mem_2_6, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_6, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X * Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_7 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var Y = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(5, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_8, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mult") {
      constraint.cont = [__mem_2_7, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_7, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X * Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_7, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_4 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "mult") {
      constraint.cont = [__prog_4_5, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(5, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_5, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_4, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X * Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_4, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_5 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(6, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_6, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "div") {
      constraint.cont = [__pc_1_5, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_5, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X / Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_8 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(6, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_9, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "div") {
      constraint.cont = [__mem_2_8, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_8, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X / Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_9 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var Y = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(6, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_10, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "div") {
      constraint.cont = [__mem_2_9, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_9, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X / Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_9, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_5 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "div") {
      constraint.cont = [__prog_4_6, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(6, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_6, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var Y = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_5, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X / Y ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_5, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_6 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(7, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_7, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "move") {
      constraint.cont = [__pc_1_6, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var _ = constraints[2].args[1]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_6, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_10 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var _ = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(7, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_11, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "move") {
      constraint.cont = [__mem_2_10, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_10, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_11 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(7, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_12, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "move") {
      constraint.cont = [__mem_2_11, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[2].args[0]
    var _ = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_11, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_11, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_6 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "move") {
      constraint.cont = [__prog_4_7, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(7, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_7, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var _ = constraints[2].args[1]

    var L_0 = constraints[3].args[0]

    if (!(B === B_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_6, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])
    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_6, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_7 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(8, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_8, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "i_mov") {
      constraint.cont = [__pc_1_7, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var C = constraints[1].args[1]

    var C_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var A_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    if (!(B === B_0 && C === C_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_7, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_12 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var _ = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(8, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_13, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "i_mov") {
      constraint.cont = [__mem_2_12, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var C = constraints[1].args[1]

    var C_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && C === C_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_12, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_13 (constraint, __n) {
    __n = __n || 0

    var C_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(8, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_14, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "i_mov") {
      constraint.cont = [__mem_2_13, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var C = constraints[1].args[1]

    var A_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && C === C_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_13, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])
    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_13, __n + 1]
    stack.push(constraint)
    return
  }

  function __mem_2_14 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var C = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(8, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_15, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "i_mov") {
      constraint.cont = [__mem_2_14, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var C_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var A_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && C === C_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_14, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])
    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_14, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_7 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "i_mov") {
      constraint.cont = [__prog_4_8, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(8, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_8, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var C = constraints[1].args[1]

    var C_0 = constraints[2].args[0]
    var X = constraints[2].args[1]

    var A_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && C === C_0 && A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_7, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])
    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_7, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_8 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(9, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_9, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mov_i") {
      constraint.cont = [__pc_1_8, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var C = constraints[2].args[1]

    var C_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    if (!(B === B_0 && A === A_0 && C === C_0 && L === L_0)) {
      constraint.cont = [__pc_1_8, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])

    ;(function () {
      var _c = new Constraint("mem", 2, [ C, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_15 (constraint, __n) {
    __n = __n || 0

    var C_0 = constraint.args[0]
    var _ = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "mem/2", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(9, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_16, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mov_i") {
      constraint.cont = [__mem_2_15, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var C = constraints[2].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && A === A_0 && C === C_0 && L === L_0)) {
      constraint.cont = [__mem_2_15, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ C, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_16 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var C = constraint.args[1]

    var constraintPattern = [ "prog/4", "mem/2", "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(9, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_17, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mov_i") {
      constraint.cont = [__mem_2_16, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var C_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && A === A_0 && C === C_0 && L === L_0)) {
      constraint.cont = [__mem_2_16, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])
    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ C, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_16, __n + 1]
    stack.push(constraint)
    return
  }

  function __mem_2_17 (constraint, __n) {
    __n = __n || 0

    var B_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(9, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_18, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "mov_i") {
      constraint.cont = [__mem_2_17, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[2].args[0]
    var C = constraints[2].args[1]

    var C_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && A === A_0 && C === C_0 && L === L_0)) {
      constraint.cont = [__mem_2_17, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])
    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ C, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_17, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_8 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "mov_i") {
      constraint.cont = [__prog_4_9, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "mem/2", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(9, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_9, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var B_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var A_0 = constraints[2].args[0]
    var C = constraints[2].args[1]

    var C_0 = constraints[3].args[0]
    var _ = constraints[3].args[1]

    var L_0 = constraints[4].args[0]

    if (!(B === B_0 && A === A_0 && C === C_0 && L === L_0)) {
      constraint.cont = [__prog_4_8, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[3])
    chr.Store.remove(constraints[4])

    ;(function () {
      var _c = new Constraint("mem", 2, [ C, X ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_8, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_9 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(10, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_10, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "const") {
      constraint.cont = [__pc_1_9, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var A_0 = constraints[1].args[0]
    var _ = constraints[1].args[1]

    if (!(A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_9, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, B ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_18 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var _ = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(10, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_19, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "const") {
      constraint.cont = [__mem_2_18, __n + 1]
      stack.push(constraint)
      return
    }
    var B = constraints[0].args[2]
    var A = constraints[0].args[3]

    var L_0 = constraints[2].args[0]

    if (!(A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_18, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, B ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __prog_4_9 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "const") {
      constraint.cont = [__prog_4_10, 0]
      stack.push(constraint)
      return
    }
    var B = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(10, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_10, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var A_0 = constraints[1].args[0]
    var _ = constraints[1].args[1]

    var L_0 = constraints[2].args[0]

    if (!(A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_9, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])
    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ A, B ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_9, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_10 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(11, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_11, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "init") {
      constraint.cont = [__pc_1_10, __n + 1]
      stack.push(constraint)
      return
    }
    var A = constraints[0].args[2]
    var _ = constraints[0].args[3]

    var A_0 = constraints[1].args[0]
    var B = constraints[1].args[1]

    if (!(A === A_0 && L === L_0)) {
      constraint.cont = [__pc_1_10, __n + 1]
      stack.push(constraint)
      return
    }

    ;(function () {
      var _c = new Constraint("mem", 2, [ B, 0 ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_19 (constraint, __n) {
    __n = __n || 0

    var A_0 = constraint.args[0]
    var B = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(11, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_20, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "init") {
      constraint.cont = [__mem_2_19, __n + 1]
      stack.push(constraint)
      return
    }
    var A = constraints[0].args[2]
    var _ = constraints[0].args[3]

    var L_0 = constraints[2].args[0]

    if (!(A === A_0 && L === L_0)) {
      constraint.cont = [__mem_2_19, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ B, 0 ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_19, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_10 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "init") {
      constraint.cont = [__prog_4_11, 0]
      stack.push(constraint)
      return
    }
    var A = constraint.args[2]
    var _ = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(11, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_11, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var A_0 = constraints[1].args[0]
    var B = constraints[1].args[1]

    var L_0 = constraints[2].args[0]

    if (!(A === A_0 && L === L_0)) {
      constraint.cont = [__prog_4_10, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("mem", 2, [ B, 0 ])
      _c.cont = [__mem_2_0, 0]
      stack.push(_c)
    })()

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_10, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_11 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "_" ]
    var lookupResult = chr.Store.lookupResume(12, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_12, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "jump") {
      constraint.cont = [__pc_1_11, __n + 1]
      stack.push(constraint)
      return
    }
    var _ = constraints[0].args[2]
    var A = constraints[0].args[3]

    if (!(L === L_0)) {
      constraint.cont = [__pc_1_11, __n + 1]
      stack.push(constraint)
      return
    }

    ;(function () {
      var _c = new Constraint("pc", 1, [ A ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __prog_4_11 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "jump") {
      constraint.cont = [__prog_4_12, 0]
      stack.push(constraint)
      return
    }
    var _ = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(12, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_12, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L_0 = constraints[1].args[0]

    if (!(L === L_0)) {
      constraint.cont = [__prog_4_11, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])

    ;(function () {
      var _c = new Constraint("pc", 1, [ A ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_11, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_12 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(13, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_13, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "cjmp") {
      constraint.cont = [__pc_1_12, __n + 1]
      stack.push(constraint)
      return
    }
    var R = constraints[0].args[2]
    var A = constraints[0].args[3]

    var R_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    if (!(X == 0 && R === R_0 && L === L_0)) {
      constraint.cont = [__pc_1_12, __n + 1]
      stack.push(constraint)
      return
    }

    ;(function () {
      var _c = new Constraint("pc", 1, [ A ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_20 (constraint, __n) {
    __n = __n || 0

    var R_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(13, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_21, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "cjmp") {
      constraint.cont = [__mem_2_20, __n + 1]
      stack.push(constraint)
      return
    }
    var R = constraints[0].args[2]
    var A = constraints[0].args[3]

    var L_0 = constraints[2].args[0]

    if (!(X == 0 && R === R_0 && L === L_0)) {
      constraint.cont = [__mem_2_20, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("pc", 1, [ A ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_20, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_12 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "cjmp") {
      constraint.cont = [__prog_4_13, 0]
      stack.push(constraint)
      return
    }
    var R = constraint.args[2]
    var A = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(13, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_13, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var R_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var L_0 = constraints[2].args[0]

    if (!(X == 0 && R === R_0 && L === L_0)) {
      constraint.cont = [__prog_4_12, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("pc", 1, [ A ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_12, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_13 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "mem/2", "_" ]
    var lookupResult = chr.Store.lookupResume(14, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_14, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "cjmp") {
      constraint.cont = [__pc_1_13, __n + 1]
      stack.push(constraint)
      return
    }
    var R = constraints[0].args[2]
    var _ = constraints[0].args[3]

    var R_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    if (!(X != 0 && R === R_0 && L === L_0)) {
      constraint.cont = [__pc_1_13, __n + 1]
      stack.push(constraint)
      return
    }

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_21 (constraint, __n) {
    __n = __n || 0

    var R_0 = constraint.args[0]
    var X = constraint.args[1]

    var constraintPattern = [ "prog/4", "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(14, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__mem_2_22, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "cjmp") {
      constraint.cont = [__mem_2_21, __n + 1]
      stack.push(constraint)
      return
    }
    var R = constraints[0].args[2]
    var _ = constraints[0].args[3]

    var L_0 = constraints[2].args[0]

    if (!(X != 0 && R === R_0 && L === L_0)) {
      constraint.cont = [__mem_2_21, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__mem_2_21, __n + 1]
    stack.push(constraint)
    return
  }

  function __prog_4_13 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "cjmp") {
      constraint.cont = [__prog_4_14, 0]
      stack.push(constraint)
      return
    }
    var R = constraint.args[2]
    var _ = constraint.args[3]

    var constraintPattern = [ "_", "mem/2", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(14, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_14, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var R_0 = constraints[1].args[0]
    var X = constraints[1].args[1]

    var L_0 = constraints[2].args[0]

    if (!(X != 0 && R === R_0 && L === L_0)) {
      constraint.cont = [__prog_4_13, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[2])

    ;(function () {
      var _c = new Constraint("pc", 1, [ L + 1 ])
      _c.cont = [__pc_1_0, 0]
      stack.push(_c)
    })()

    constraint.cont = [__prog_4_13, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_14 (constraint, __n) {
    __n = __n || 0

    var L_0 = constraint.args[0]

    var constraintPattern = [ "prog/4", "_" ]
    var lookupResult = chr.Store.lookupResume(15, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__pc_1_15, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L = constraints[0].args[0]
    if (constraints[0].args[1] !== "halt") {
      constraint.cont = [__pc_1_14, __n + 1]
      stack.push(constraint)
      return
    }
    var _ = constraints[0].args[2]
    var __0 = constraints[0].args[3]

    if (!(_ === __0 && L === L_0)) {
      constraint.cont = [__pc_1_14, __n + 1]
      stack.push(constraint)
      return
    }

    // active constraint gets removed
  }

  function __prog_4_14 (constraint, __n) {
    __n = __n || 0

    var L = constraint.args[0]
    if (constraint.args[1] !== "halt") {
      constraint.cont = [__prog_4_15, 0]
      stack.push(constraint)
      return
    }
    var _ = constraint.args[2]
    var __0 = constraint.args[3]

    var constraintPattern = [ "_", "pc/1" ]
    var lookupResult = chr.Store.lookupResume(15, constraintPattern, constraint, __n)
    if (lookupResult === false) {
      constraint.cont = [__prog_4_15, 0]
      stack.push(constraint)
      return
    }
    var constraints = lookupResult.res

    var L_0 = constraints[1].args[0]

    if (!(_ === __0 && L === L_0)) {
      constraint.cont = [__prog_4_14, __n + 1]
      stack.push(constraint)
      return
    }

    chr.Store.remove(constraints[1])

    constraint.cont = [__prog_4_14, __n + 1]
    stack.push(constraint)
    return
  }

  function __pc_1_15 (constraint, __n) {
    __n = __n || 0

    var _ = constraint.args[0]

    ;(function () {
      var _c = new Constraint("fail", 0, [  ])
      _c.cont = [__fail_0_0, 0]
      stack.push(_c)
    })()

    // active constraint gets removed
  }

  function __mem_2_22 (constraint) {
    constraint.cont = null
    chr.Store.add(constraint)
  }

  function __fail_0_0 (constraint) {
    constraint.cont = null
    chr.Store.add(constraint)
  }

  function __prog_4_15 (constraint) {
    constraint.cont = null
    chr.Store.add(constraint)
  }

  function __pc_1_16 (constraint) {
    constraint.cont = null
    chr.Store.add(constraint)
  }

  function mem () {
    var args = Array.prototype.slice.call(arguments)
    var arity = arguments.length
    var functor = "mem/" + arity
    var constraint = new Constraint("mem", arity, args)
    if (arity === 2) {
      constraint.cont = [__mem_2_0, ]
    } else {
      throw new Error("Undefined constraint: " + functor)
    }
    stack.push(constraint)

    trampoline()
  }

  function fail () {
    var args = Array.prototype.slice.call(arguments)
    var arity = arguments.length
    var functor = "fail/" + arity
    var constraint = new Constraint("fail", arity, args)
    if (arity === 0) {
      constraint.cont = [__fail_0_0, ]
    } else {
      throw new Error("Undefined constraint: " + functor)
    }
    stack.push(constraint)

    trampoline()
  }

  function prog () {
    var args = Array.prototype.slice.call(arguments)
    var arity = arguments.length
    var functor = "prog/" + arity
    var constraint = new Constraint("prog", arity, args)
    if (arity === 4) {
      constraint.cont = [__prog_4_0, ]
    } else {
      throw new Error("Undefined constraint: " + functor)
    }
    stack.push(constraint)

    trampoline()
  }

  function pc () {
    var args = Array.prototype.slice.call(arguments)
    var arity = arguments.length
    var functor = "pc/" + arity
    var constraint = new Constraint("pc", arity, args)
    if (arity === 1) {
      constraint.cont = [__pc_1_0, ]
    } else {
      throw new Error("Undefined constraint: " + functor)
    }
    stack.push(constraint)

    trampoline()
  }

  chr.mem = mem
  chr.fail = fail
  chr.prog = prog
  chr.pc = pc

  return chr
})()
