extends Node
class_name BaseLoader

var items = {}

var TYPES              := []
var RESOURCE_DIR       := ""
var RECURSIVE          := true
var _resources_to_load := []


func _notification(what: int) -> void:
	if what == NOTIFICATION_READY:
		if get_tree().current_scene.scene_file_path != "res://Boot.tscn":
			get_resource_list() # warning-ignore:return_value_discarded
			start_loading()

func start_loading(progress_bar: ProgressBar = null) -> void:
	for i in len(_resources_to_load):
		var resource_path: String = _resources_to_load[i]
		var file_name: String     = resource_path.split(".")[0]
		var resource              = load(RESOURCE_DIR + resource_path)

		items[file_name] = resource
		if progress_bar:
			progress_bar.value += 1
			if int(progress_bar.value) % 4 == 0:
				await get_tree().process_frame


func get_resource_list() -> Array:
	if _resources_to_load.is_empty():
		_resources_to_load = _get_resource_list()
	return _resources_to_load


func _get_resource_list(subdir: String = "") -> Array:
	var dir      := DirAccess.open(RESOURCE_DIR + subdir)
	var res_list := []

	if subdir != "":
		subdir += "/"

	if dir:
		dir.list_dir_begin()  # warning-ignore:return_value_discarded# TODOGODOT4 fill missing arguments https://github.com/godotengine/godot/pull/40547
		var file_name = dir.get_next()

		while file_name != "":
			if dir.current_is_dir():
				if RECURSIVE:
					res_list.append_array(
						_get_resource_list(subdir + file_name)
					)

			else:
				if OS.has_feature("template"):
					file_name = file_name.replace(".import", "").replace(".remap", "")
				var results = file_name.split(".")
				if results[-1] in TYPES:
					res_list.append(subdir + file_name)

			file_name = dir.get_next()

	return res_list
