using System.Collections;
using System.Collections.Generic;
using UnityEngine;

[RequireComponent(typeof(AudioSource))]
public class StoryEngine : MonoBehaviour
{
    public delegate void HandlePassage(StoryEngine engine, params Object[] args);
    Dictionary<string, HandlePassage> callbacks = new Dictionary<string, HandlePassage>();
    Dictionary<string, AudioClip> audioClips = new Dictionary<string, AudioClip>();
    Dictionary<string, Animator> actors = new Dictionary<string, Animator>();
    AudioSource source;
    // Start is called before the first frame update

    void Start()
    {
        source = GetComponent<AudioSource>();
    }

    
    public void LoudAudioClips(string path)
    {
        audioClips = new Dictionary<string, AudioClip>();
        var clips = Resources.LoadAll<AudioClip>(path);
        foreach (var clip in clips)
        {
            audioClips.Add(clip.name, clip);
        }
        Debug.Log(audioClips);
    }

    public void AddActor(string path)
    {
        GameObject gameObject = GameObject.Find(path);
        Animator animator = gameObject.GetComponent<Animator>();
        var result = path.Split('/');
        string name = result[result.Length - 1];
        if (animator)
        {
            actors.Add(name, animator);
        }
    }

    public void AddActor(string name, Animator animator)
    {
        actors.Add(name, animator);
    }

    public void PlayClip(string name)
    {
        source.clip = audioClips[name];
        source.Play();
    }

    public void SetActorTrigger(string actorName, string name)
    {
        actors[actorName].SetTrigger(name);
    }

    public float GetClipLength(string name)
    {
        return audioClips[name].length;
    }
    public void Register(string name, HandlePassage callback)
    {
        callbacks.Add(name, callback);
    }

    public void Run(string name, params Object[] args)
    {
        if (callbacks.ContainsKey(name)) {
            callbacks[name](this, args);
        }
    }

    public void Run(float delay, string name, params Object[] args)
    {
        StartCoroutine(WaitAndRun(delay, name, args));
    }

    private IEnumerator WaitAndRun(float delay, string name, params Object[] args)
    {
        yield return new WaitForSeconds(delay);
        Run(name, args);
    }
    
}
