extends Node2D
var world = Tabulacrum.new()

@onready var window_title = get_window().title
func _ready() -> void:
	for _i in range(1000):
		world.conjure_entity() \
			.it_is_a(["circle"]) \
			.give_it(
				{ position = Vector2(randi_range(100, 500), randi_range(100, 500))
				, speed = randf_range(0, 5)
				, time = randf() * 2 * PI
				, size = randf_range(2,5)
				}
			) \
			.seal()

func _draw() -> void:

	for id in world.grab_tome("circle"):
		var entity = world.summon_entity(id)
		var orbit = Vector2 \
			( cos(entity.time) * 10 + entity.position.x
			, sin(entity.time) * 10 + entity.position.y
			)
		draw_circle(orbit, entity.size, Color.WHITE)

func _process(delta: float) -> void:
	for id in world.grab_tome("time"):
		var entity = world.summon_entity(id)
		entity.time += delta * entity.speed
	get_window().title = "%s - %s fps" % [window_title, Engine.get_frames_per_second()]
	queue_redraw()
