extends Sequence

func setup():
	backdrop_image('qs-background', preload('res://imgs/events/QuickShot00_background.png'))
	backdrop_image('qs-table', preload('res://imgs/events/QuickShot01_table.png'))
	backdrop_image('qs-guy', preload('res://imgs/events/QuickShot02_guy.png'))

func intro():
	fade_out()

	set_backdrop('qs-background')
	add_backdrop('qs-table')
	add_backdrop('qs-guy')
	fade_in()
	
	say_left("""
		Back for another go, huh? Look, since my boss isn't around how about I give you around on the house.
	""")
	respond("> Play Game")

	say_left("""
		Same rules as last time:

		Get 30 points and ya get the small prize.
		
		Get 50 points and ya can get a big prize.
	""")
	next()

	goto('play_minigame')

func play_minigame() -> void:
	await_minigame(Minigames.QUICK_SHOT, 'minigame_ended')

func minigame_ended(userdata):
	if userdata.score < 30:
		execute('no_prize')

	elif userdata.score < 50:
		execute('small_prize')

	else:
		execute('large_prize')

func no_prize() -> void:
	say_left('ooo, tough luck. Maybe you want to have another go?')
	pick([
		'> Leave empty handed', 'end',
		'> Play again', 'play_minigame'
	])

func small_prize() -> void:
	say_left('Alright, you won the small prize. Maybe you could get the big prize next time~')
	respond('> Take small prize')
	
	give_prize([
		Items.small_prize.PLASTIC_TRUMPET,
		Items.small_prize.BAG_O_BUGS,
		Items.small_prize.STUFFED_BULL,
	])

	
	end()


func large_prize() -> void:
	say_left("""
		Way to go! The grand prize is all yours!
	""")
	respond('> Take big prize')
	
	give_prize([
		Items.large_prize.BIG_STUFFED_BEAR,
		Items.large_prize.WEIRD_BALL,
		Items.large_prize.STUFFED_GATOR
	])
	
	end()
