local min, max, huge = math.min, math.max, math.huge
local machine = {}

machine.counters = {
	["update scene state"] = 0,
	["draw scene"] = 0,
	["present current frame"] = 0,
	["sleep for 1ms"] = 0,
	["next cycle"] = 0,
	["updating scene"] = 0,
	["@present"] = 0,
	["@sleep"] = 0,
	["@quit"] = 0,
	["@poll inputs"] = 0,
	["@quit love"] = 0,
	["@text received"] = 0,
	["@clear screen"] = 0,
	["@backspace was pressed"] = 0,
	["@draw buffer"] = 0,
	["@new line was pressed"] = 0,
	["@is backspace pressed"] = 0,
	["@is new line pressed"] = 0,
	["@is left arrow pressed"] = 0,
	["@down arrow was pressed"] = 0,
	["@is up arrow pressed"] = 0,
	["@up arrow was pressed"] = 0,
	["@is right arrow pressed"] = 0,
	["@right arrow was pressed"] = 0,
	["@push text"] = 0,
	["@pop text"] = 0,
	["@break text"] = 0,
	["@draw cursor"] = 0,
	["@move cursor left"] = 0,
	["@move cursor up"] = 0,
	["@exit code"] = 0,
	["@move cursor down"] = 0,
	["@move cursor right"] = 0,
	["push text to buffer"] = 0,
	["pop text from buffer"] = 0,
	["break text"] = 0,
	["move cursor left"] = 0,
	["move cursor up"] = 0,
	["move cursor down"] = 0,
	["move cursor right"] = 0,
	["@text input"] = 0,
	["drawing scene"] = 0,
	["draw buffer"] = 0,
	["draw cursor"] = 0,
	["@left arrow was pressed"] = 0,
	["handling inputs"] = 0,
	["handle text edit"] = 0,
	["handle cursor motion"] = 0,
	["run main loop"] = 1,
	["handle text input"] = 0,
	["handle backspace"] = 0,
	["handle new line"] = 0,
	["check for text input event"] = 0,
	["push received text to buffer"] = 0,
	["back character from buffer"] = 0,
	["then pop text from buffer"] = 0,
	["insert new line"] = 0,
	["@is down arrow pressed"] = 0,
	["move cursor"] = 0,
	["@step timer"] = 0,
	["poll inputs"] = 0,
	["handle inputs"] = 0,
	["run current frame"] = 0,
	["step timer"] = 0,
	["clear the screen"] = 0,
}

function machine.on_poll_inputs(counters)
end

function machine.on_quit_love(counters)
end

function machine.on_step_timer(counters)
end

function machine.on_clear_screen(counters)
end

function machine.on_present(counters)
end

function machine.on_sleep(counters, sleep)
end

function machine.on_text_input(counters)
end

function machine.on_draw_buffer(counters)
end

function machine.on_is_backspace_pressed(counters)
end

function machine.on_is_new_line_pressed(counters)
end

function machine.on_is_left_arrow_pressed(counters)
end

function machine.on_is_up_arrow_pressed(counters)
end

function machine.on_is_down_arrow_pressed(counters)
end

function machine.on_is_right_arrow_pressed(counters)
end

function machine.on_push_text(counters)
end

function machine.on_pop_text(counters)
end

function machine.on_break_text(counters)
end

function machine.on_draw_cursor(counters)
end

function machine.on_move_cursor_left(counters)
end

function machine.on_move_cursor_up(counters)
end

function machine.on_move_cursor_down(counters)
end

function machine.on_move_cursor_right(counters)
end

function match(self, counters)
	if counters["@poll inputs"] > 0 then
		self.on_poll_inputs(counters)
		counters["@poll inputs"] = 0
		return true
	end
	if counters["@quit love"] > 0 then
		counters["@exit code"] = 0
		self.on_quit_love(counters)
		counters["@quit love"] = 0
		return true
	end
	if counters["@step timer"] > 0 then
		self.on_step_timer(counters)
		counters["@step timer"] = 0
		return true
	end
	if counters["@clear screen"] > 0 then
		self.on_clear_screen(counters)
		counters["@clear screen"] = 0
		return true
	end
	if counters["@present"] > 0 then
		self.on_present(counters)
		counters["@present"] = 0
		return true
	end
	if counters["@sleep"] > 0 then
		self.on_sleep(counters, counters["@sleep"])
		counters["@sleep"] = 0
		return true
	end
	if counters["@text input"] > 0 then
		counters["@text received"] = 0
		self.on_text_input(counters)
		counters["@text input"] = 0
		return true
	end
	if counters["@draw buffer"] > 0 then
		self.on_draw_buffer(counters)
		counters["@draw buffer"] = 0
		return true
	end
	if counters["@is backspace pressed"] > 0 then
		counters["@backspace was pressed"] = 0
		self.on_is_backspace_pressed(counters)
		counters["@is backspace pressed"] = 0
		return true
	end
	if counters["@is new line pressed"] > 0 then
		counters["@new line was pressed"] = 0
		self.on_is_new_line_pressed(counters)
		counters["@is new line pressed"] = 0
		return true
	end
	if counters["@is left arrow pressed"] > 0 then
		counters["@left arrow was pressed"] = 0
		self.on_is_left_arrow_pressed(counters)
		counters["@is left arrow pressed"] = 0
		return true
	end
	if counters["@is up arrow pressed"] > 0 then
		counters["@up arrow was pressed"] = 0
		self.on_is_up_arrow_pressed(counters)
		counters["@is up arrow pressed"] = 0
		return true
	end
	if counters["@is down arrow pressed"] > 0 then
		counters["@down arrow was pressed"] = 0
		self.on_is_down_arrow_pressed(counters)
		counters["@is down arrow pressed"] = 0
		return true
	end
	if counters["@is right arrow pressed"] > 0 then
		counters["@right arrow was pressed"] = 0
		self.on_is_right_arrow_pressed(counters)
		counters["@is right arrow pressed"] = 0
		return true
	end
	if counters["@push text"] > 0 then
		self.on_push_text(counters)
		counters["@push text"] = 0
		return true
	end
	if counters["@pop text"] > 0 then
		self.on_pop_text(counters)
		counters["@pop text"] = 0
		return true
	end
	if counters["@break text"] > 0 then
		self.on_break_text(counters)
		counters["@break text"] = 0
		return true
	end
	if counters["@draw cursor"] > 0 then
		self.on_draw_cursor(counters)
		counters["@draw cursor"] = 0
		return true
	end
	if counters["@move cursor left"] > 0 then
		self.on_move_cursor_left(counters)
		counters["@move cursor left"] = 0
		return true
	end
	if counters["@move cursor up"] > 0 then
		self.on_move_cursor_up(counters)
		counters["@move cursor up"] = 0
		return true
	end
	if counters["@move cursor down"] > 0 then
		self.on_move_cursor_down(counters)
		counters["@move cursor down"] = 0
		return true
	end
	if counters["@move cursor right"] > 0 then
		self.on_move_cursor_right(counters)
		counters["@move cursor right"] = 0
		return true
	end
	if counters["push text to buffer"] > 0 then
		acc = counters["push text to buffer"]
		counters["push text to buffer"] = max(counters["push text to buffer"] - acc, 0)
		counters["@push text"] = counters["@push text"] + acc * 1
		return true
	end
	if counters["pop text from buffer"] > 0 then
		acc = counters["pop text from buffer"]
		counters["pop text from buffer"] = max(counters["pop text from buffer"] - acc, 0)
		counters["@pop text"] = counters["@pop text"] + acc * 1
		return true
	end
	if counters["break text"] > 0 then
		acc = counters["break text"]
		counters["break text"] = max(counters["break text"] - acc, 0)
		counters["@break text"] = counters["@break text"] + acc * 1
		return true
	end
	if counters["move cursor left"] > 0 then
		acc = counters["move cursor left"]
		counters["move cursor left"] = max(counters["move cursor left"] - acc, 0)
		counters["@move cursor left"] = counters["@move cursor left"] + acc * 1
		return true
	end
	if counters["move cursor up"] > 0 then
		acc = counters["move cursor up"]
		counters["move cursor up"] = max(counters["move cursor up"] - acc, 0)
		counters["@move cursor up"] = counters["@move cursor up"] + acc * 1
		return true
	end
	if counters["move cursor down"] > 0 then
		acc = counters["move cursor down"]
		counters["move cursor down"] = max(counters["move cursor down"] - acc, 0)
		counters["@move cursor down"] = counters["@move cursor down"] + acc * 1
		return true
	end
	if counters["move cursor right"] > 0 then
		acc = counters["move cursor right"]
		counters["move cursor right"] = max(counters["move cursor right"] - acc, 0)
		counters["@move cursor right"] = counters["@move cursor right"] + acc * 1
		return true
	end
	if counters["drawing scene"] > 0 then
		acc = counters["drawing scene"]
		counters["drawing scene"] = max(counters["drawing scene"] - acc, 0)
		counters["draw cursor"] = counters["draw cursor"] + acc * 1
		counters["draw buffer"] = counters["draw buffer"] + acc * 1
		return true
	end
	if counters["draw buffer"] > 0 then
		acc = counters["draw buffer"]
		counters["draw buffer"] = max(counters["draw buffer"] - acc, 0)
		counters["@draw buffer"] = counters["@draw buffer"] + acc * 1
		return true
	end
	if counters["draw cursor"] > 0 then
		acc = counters["draw cursor"]
		counters["draw cursor"] = max(counters["draw cursor"] - acc, 0)
		counters["@draw cursor"] = counters["@draw cursor"] + acc * 1
		return true
	end
	if counters["handling inputs"] > 0 then
		acc = counters["handling inputs"]
		counters["handling inputs"] = max(counters["handling inputs"] - acc, 0)
		counters["handle cursor motion"] = counters["handle cursor motion"] + acc * 1
		counters["handle text edit"] = counters["handle text edit"] + acc * 1
		return true
	end
	if counters["handle text edit"] > 0 then
		acc = counters["handle text edit"]
		counters["handle text edit"] = max(counters["handle text edit"] - acc, 0)
		counters["handle text input"] = counters["handle text input"] + acc * 1
		counters["handle backspace"] = counters["handle backspace"] + acc * 1
		counters["handle new line"] = counters["handle new line"] + acc * 1
		return true
	end
	if counters["handle text input"] > 0 then
		acc = counters["handle text input"]
		counters["handle text input"] = max(counters["handle text input"] - acc, 0)
		counters["push received text to buffer"] = counters["push received text to buffer"] + acc * 1
		counters["check for text input event"] = counters["check for text input event"] + acc * 1
		return true
	end
	if counters["check for text input event"] > 0 then
		acc = counters["check for text input event"]
		counters["check for text input event"] = max(counters["check for text input event"] - acc, 0)
		counters["@text input"] = counters["@text input"] + acc * 1
		return true
	end
	if counters["push received text to buffer"] > 0 and counters["@text received"] > 0 then
		local acc = huge
		acc = min(acc, counters["push received text to buffer"])
		acc = min(acc, counters["@text received"])
		counters["push received text to buffer"] = max(counters["push received text to buffer"] - acc, 0)
		counters["@text received"] = max(counters["@text received"] - acc, 0)
		counters["handle text input"] = counters["handle text input"] + acc * 1
		counters["move cursor right"] = counters["move cursor right"] + acc * 1
		counters["push text to buffer"] = counters["push text to buffer"] + acc * 1
		return true
	end
	if counters["push received text to buffer"] > 0 then
		acc = counters["push received text to buffer"]
		counters["push received text to buffer"] = max(counters["push received text to buffer"] - acc, 0)
		return true
	end
	if counters["handle backspace"] > 0 then
		acc = counters["handle backspace"]
		counters["handle backspace"] = max(counters["handle backspace"] - acc, 0)
		counters["back character from buffer"] = counters["back character from buffer"] + acc * 1
		counters["@is backspace pressed"] = counters["@is backspace pressed"] + acc * 1
		return true
	end
	if counters["back character from buffer"] > 0 and counters["@backspace was pressed"] > 0 then
		local acc = huge
		acc = min(acc, counters["@backspace was pressed"])
		acc = min(acc, counters["back character from buffer"])
		counters["back character from buffer"] = max(counters["back character from buffer"] - acc, 0)
		counters["@backspace was pressed"] = max(counters["@backspace was pressed"] - acc, 0)
		counters["then pop text from buffer"] = counters["then pop text from buffer"] + acc * 1
		counters["move cursor left"] = counters["move cursor left"] + acc * 1
		return true
	end
	if counters["then pop text from buffer"] > 0 then
		acc = counters["then pop text from buffer"]
		counters["then pop text from buffer"] = max(counters["then pop text from buffer"] - acc, 0)
		counters["pop text from buffer"] = counters["pop text from buffer"] + acc * 1
		return true
	end
	if counters["back character from buffer"] > 0 then
		acc = counters["back character from buffer"]
		counters["back character from buffer"] = max(counters["back character from buffer"] - acc, 0)
		return true
	end
	if counters["handle new line"] > 0 then
		acc = counters["handle new line"]
		counters["handle new line"] = max(counters["handle new line"] - acc, 0)
		counters["insert new line"] = counters["insert new line"] + acc * 1
		counters["@is new line pressed"] = counters["@is new line pressed"] + acc * 1
		return true
	end
	if counters["insert new line"] > 0 and counters["@new line was pressed"] > 0 then
		local acc = huge
		acc = min(acc, counters["@new line was pressed"])
		acc = min(acc, counters["insert new line"])
		counters["insert new line"] = max(counters["insert new line"] - acc, 0)
		counters["@new line was pressed"] = max(counters["@new line was pressed"] - acc, 0)
		counters["break text"] = counters["break text"] + acc * 1
		return true
	end
	if counters["insert new line"] > 0 then
		acc = counters["insert new line"]
		counters["insert new line"] = max(counters["insert new line"] - acc, 0)
		return true
	end
	if counters["handle cursor motion"] > 0 then
		acc = counters["handle cursor motion"]
		counters["handle cursor motion"] = max(counters["handle cursor motion"] - acc, 0)
		counters["@is up arrow pressed"] = counters["@is up arrow pressed"] + acc * 1
		counters["@is down arrow pressed"] = counters["@is down arrow pressed"] + acc * 1
		counters["@is right arrow pressed"] = counters["@is right arrow pressed"] + acc * 1
		counters["move cursor"] = counters["move cursor"] + acc * 1
		counters["@is left arrow pressed"] = counters["@is left arrow pressed"] + acc * 1
		return true
	end
	if counters["move cursor"] > 0 and counters["@left arrow was pressed"] > 0 then
		local acc = huge
		acc = min(acc, counters["@left arrow was pressed"])
		acc = min(acc, counters["move cursor"])
		counters["move cursor"] = max(counters["move cursor"] - acc, 0)
		counters["@left arrow was pressed"] = max(counters["@left arrow was pressed"] - acc, 0)
		counters["move cursor left"] = counters["move cursor left"] + acc * 1
		counters["move cursor"] = counters["move cursor"] + acc * 1
		return true
	end
	if counters["move cursor"] > 0 and counters["@up arrow was pressed"] > 0 then
		local acc = huge
		acc = min(acc, counters["@up arrow was pressed"])
		acc = min(acc, counters["move cursor"])
		counters["move cursor"] = max(counters["move cursor"] - acc, 0)
		counters["@up arrow was pressed"] = max(counters["@up arrow was pressed"] - acc, 0)
		counters["move cursor up"] = counters["move cursor up"] + acc * 1
		counters["move cursor"] = counters["move cursor"] + acc * 1
		return true
	end
	if counters["move cursor"] > 0 and counters["@down arrow was pressed"] > 0 then
		local acc = huge
		acc = min(acc, counters["@down arrow was pressed"])
		acc = min(acc, counters["move cursor"])
		counters["move cursor"] = max(counters["move cursor"] - acc, 0)
		counters["@down arrow was pressed"] = max(counters["@down arrow was pressed"] - acc, 0)
		counters["move cursor down"] = counters["move cursor down"] + acc * 1
		counters["move cursor"] = counters["move cursor"] + acc * 1
		return true
	end
	if counters["move cursor"] > 0 and counters["@right arrow was pressed"] > 0 then
		local acc = huge
		acc = min(acc, counters["@right arrow was pressed"])
		acc = min(acc, counters["move cursor"])
		counters["move cursor"] = max(counters["move cursor"] - acc, 0)
		counters["@right arrow was pressed"] = max(counters["@right arrow was pressed"] - acc, 0)
		counters["move cursor right"] = counters["move cursor right"] + acc * 1
		counters["move cursor"] = counters["move cursor"] + acc * 1
		return true
	end
	if counters["move cursor"] > 0 then
		acc = counters["move cursor"]
		counters["move cursor"] = max(counters["move cursor"] - acc, 0)
		return true
	end
	if counters["run main loop"] > 0 then
		acc = counters["run main loop"]
		counters["run main loop"] = max(counters["run main loop"] - acc, 0)
		counters["handle inputs"] = counters["handle inputs"] + acc * 1
		counters["run current frame"] = counters["run current frame"] + acc * 1
		counters["poll inputs"] = counters["poll inputs"] + acc * 1
		return true
	end
	if counters["poll inputs"] > 0 then
		acc = counters["poll inputs"]
		counters["poll inputs"] = max(counters["poll inputs"] - acc, 0)
		counters["@poll inputs"] = counters["@poll inputs"] + acc * 1
		return true
	end
	if counters["handle inputs"] > 0 then
		acc = counters["handle inputs"]
		counters["handle inputs"] = max(counters["handle inputs"] - acc, 0)
		counters["handling inputs"] = counters["handling inputs"] + acc * 1
		return true
	end
	if counters["run current frame"] > 0 and counters["@quit"] > 0 then
		local acc = huge
		acc = min(acc, counters["@quit"])
		acc = min(acc, counters["run current frame"])
		counters["run current frame"] = max(counters["run current frame"] - acc, 0)
		counters["@quit"] = max(counters["@quit"] - acc, 0)
		counters["@quit love"] = counters["@quit love"] + acc * 1
		return true
	end
	if counters["run current frame"] > 0 then
		acc = counters["run current frame"]
		counters["run current frame"] = max(counters["run current frame"] - acc, 0)
		counters["update scene state"] = counters["update scene state"] + acc * 1
		counters["draw scene"] = counters["draw scene"] + acc * 1
		counters["present current frame"] = counters["present current frame"] + acc * 1
		counters["sleep for 1ms"] = counters["sleep for 1ms"] + acc * 1
		counters["next cycle"] = counters["next cycle"] + acc * 1
		counters["step timer"] = counters["step timer"] + acc * 1
		counters["clear the screen"] = counters["clear the screen"] + acc * 1
		return true
	end
	if counters["step timer"] > 0 then
		acc = counters["step timer"]
		counters["step timer"] = max(counters["step timer"] - acc, 0)
		counters["@step timer"] = counters["@step timer"] + acc * 1
		return true
	end
	if counters["clear the screen"] > 0 then
		acc = counters["clear the screen"]
		counters["clear the screen"] = max(counters["clear the screen"] - acc, 0)
		counters["@clear screen"] = counters["@clear screen"] + acc * 1
		return true
	end
	if counters["update scene state"] > 0 then
		acc = counters["update scene state"]
		counters["update scene state"] = max(counters["update scene state"] - acc, 0)
		counters["updating scene"] = counters["updating scene"] + acc * 1
		return true
	end
	if counters["draw scene"] > 0 then
		acc = counters["draw scene"]
		counters["draw scene"] = max(counters["draw scene"] - acc, 0)
		counters["drawing scene"] = counters["drawing scene"] + acc * 1
		return true
	end
	if counters["present current frame"] > 0 then
		acc = counters["present current frame"]
		counters["present current frame"] = max(counters["present current frame"] - acc, 0)
		counters["@present"] = counters["@present"] + acc * 1
		return true
	end
	if counters["sleep for 1ms"] > 0 then
		acc = counters["sleep for 1ms"]
		counters["sleep for 1ms"] = max(counters["sleep for 1ms"] - acc, 0)
		counters["@sleep"] = counters["@sleep"] + acc * 1
		return true
	end
	if counters["next cycle"] > 0 then
		acc = counters["next cycle"]
		counters["next cycle"] = max(counters["next cycle"] - acc, 0)
		counters["run main loop"] = counters["run main loop"] + acc * 1
		return true
	end
	return false
end

function machine:run()
    local counters = self.counters
    while match(self, counters) do end
end

return machine