local function rpn_caculator()
    local char = io.read(1)
    local acc, op = nil, {}
    local data_stack = {}
    while char do
        if char:match("%s") then
            if #op ~= 0 then
                local op_to_eval = table.concat(op)
                op = {}
                if op_to_eval == "+" then
                    local y, x = data_stack[#data_stack], data_stack[#data_stack - 1]
                    table.remove(data_stack) table.remove(data_stack)
                    table.insert(data_stack, x + y)
                elseif op_to_eval == "*" then
                    local y, x = data_stack[#data_stack], data_stack[#data_stack - 1]
                    table.remove(data_stack) table.remove(data_stack)
                    table.insert(data_stack, x * y)
                elseif op_to_eval == "/" then
                    local y, x = data_stack[#data_stack], data_stack[#data_stack - 1]
                    table.remove(data_stack) table.remove(data_stack)
                    table.insert(data_stack, x / y)
                elseif op_to_eval == "-" then
                    local y, x = data_stack[#data_stack], data_stack[#data_stack - 1]
                    table.remove(data_stack) table.remove(data_stack)
                    table.insert(data_stack, x - y)
                elseif op_to_eval == "isqrt" then
                    local x = data_stack[#data_stack]
                    table.remove(data_stack)
                    table.insert(data_stack, x)
                elseif op_to_eval == "dup" then
                    local x = data_stack[#data_stack]
                    table.remove(data_stack)
                    table.insert(data_stack, x)
                    table.insert(data_stack, x)
                elseif op_to_eval == "swap" then
                    local y, x = data_stack[#data_stack], data_stack[#data_stack - 1]
                    table.remove(data_stack) table.remove(data_stack)
                    table.insert(data_stack, y)
                    table.insert(data_stack, x)
                end
            elseif acc then
                table.insert(data_stack, acc)
                acc = nil
            end
            io.write("> ")
            for _, data in ipairs(data_stack) do
                io.write(data) io.write(" ")
            end
            io.write("\n")
        elseif char:match("%d") then
            acc = acc and (acc * 10 + tonumber(char)) or tonumber(char)
        else
            if acc then
                table.insert(data_stack, acc)
                acc = nil
            end
            table.insert(op, char)
        end

        char = io.read(1)
    end
end

rpn_caculator()