extends Node

const BLACK_BAR_IMAGE = preload("res://assets/imgs/ui/bg_img.png")
# Declare member variables here. Examples:
# var a: int = 2
# var b: String = "text"


# Called when the node enters the scene tree for the first time.
func _ready() -> void:
	SimpleState.register("sequence",
		{ current_sequence = "NONE"
		, current_line_id  = ""
		, background       = []
		, dialogue_pos     = "left"
		, blackout_visible = false
		, dialogue_visible = false
		, characters       = {}
		, next_fade        = EventPlayer.NextFade.FADE_OUT
		}
	)

	SimpleState.register("explore",
		{ location         = "Games"
		, current_minigame = "NONE"
		, history          = []
		, losing_streak    = 0
		, refuse_streak    = 0
		, places_closed    = {}
		}
	)

	SimpleState.register("system",
		{ start_time      = Time.get_unix_time_from_system()
		, music_track     = "menu-theme"
		, saving_disabled = false
		, high_scores     = {}
		}
	)

	SimpleState.register("inventory",
		{ items = []
		, traps = {}
		}
	)

	SimpleState.register("memory",
		{ attractions = {}
		, minigames   = {}
		, npcs        = {}
		, parasites   = {}
		, passages    = {}
		, flags       = {}
		}
	)

	SimpleState.register("settings",
		{ master_volume = 0.0
		, music_volume  = 1.0
		, sfx_volume    = 1.0
		, pixel_jitter  = true
		, grace_zone    = 60.0
		, fullscreen    = false
		, warning_seen  = false
		}
	)

	SimpleState.register("your_state",
		{ money        = 50
		, lust         = 0
		, morals       = 9
		, tickets      = 0
		, escaping     = true
		}
	)

	SimpleState.register("their_state",
		{ psyche         = 9
		, lust           = 0
		, seen_parasites = false
		}
	)

	SimpleState.register("temp", { values = {} })
