local function push(self, value)
    self.n = self.n + 1
    table.insert(self, value)
end

local function pop(self)
    local value = self[self.n]
    self[self.n] = nil 
    self.n = self.n - 1
    return value
end

local function peek(self)
    return self[self.n]
end

local function create_stack(object, name)
    object[name] = { n = 0 , push = push, pop = pop, peek = peek }
end

LOBBY = {}
create_stack(LOBBY, "lobby")
LOBBY["lobby"]:push(LOBBY)

function PUSH(stack, value)
    if not LOBBY[stack] then create_stack(LOBBY, stack) end
    LOBBY[stack]:push(value)
end

function PEEK(stack)
    assert(LOBBY[stack], "Stack underflow")
    assert(LOBBY[stack].n > 0, "Stack underflow")
    return LOBBY[stack]:peek()
end

function POP(stack)
    assert(LOBBY[stack], "Stack underflow")
    assert(LOBBY[stack].n > 0, "Stack underflow")
    return LOBBY[stack]:pop()
end

function PUSHTO(object, stack, value)
    if not object[stack] then
        create_stack(object, stack)
    end
    object[stack]:push(value)
end

function POPFROM(object, stack)
    assert(object[stack], "Stack underflow in external object.")
    assert(object[stack].n > 0, "Stack underflow in external object.")
    return object[stack]:pop()
end

function _become()
    LOBBY = POP('')
end

function _me()
    PUSH('', LOBBY)
end

function _object()
    PUSH('', {})
end
