#include <limits.h>
#include <stdio.h>

#define STACK_SIZE 10
#define STACK_COUNT 10
#define SIZE_BITS(type) (sizeof(type) * CHAR_BIT)
typedef unsigned int cell;

typedef struct pair pair;
struct pair {
    cell first;
    cell second;
};

typedef struct stack stack;
struct stack {
    cell data[STACK_SIZE];
    pair top;
};

typedef struct core core;
struct core {
    stack stacks[STACK_COUNT];
    cell stack;
};

cell empty(stack *stack) {
    return stack->top.first == 0 && stack->top.second == 0;
}

cell full(stack *stack) {
    return stack->top.first == STACK_SIZE && stack->top.second == SIZE_BITS(cell);
}

cell peek(stack *stack) {
    if(stack == NULL) {
        return 0;
    }
    return stack->data[stack->top.first] & 1;
}

cell pop(stack *stack) {
    cell bit = 0;
    if(stack == NULL || empty(stack)) {
        return 0;
    }
    bit = peek(stack);
    stack->data[stack->top.first] >>= 1;
    stack->top.second--;
    if(stack->top.second == 0 && stack->top.first != 0) {
        stack->top.second = SIZE_BITS(cell);
        stack->top.first--;
    }
    return bit;
}

void push(stack *stack, cell bit) {
    if(stack == NULL || full(stack)) {
        return;
    }
    stack->data[stack->top.first] <<= 1;
    stack->data[stack->top.first] |= bit;
    stack->top.second++;
    if(stack->top.second == SIZE_BITS(cell)) {
        stack->top.second = 0;
        stack->top.first++;
    }
    return;
}

void print_stack(stack *stack) {
    cell iterator = 0;
    while(iterator < stack->top.second) {
        printf("%d", (stack->data[stack->top.first] >> iterator) & 1);
        iterator++;
    }
}

void right(core *core) {
    core->stack++;
    if(core->stack == STACK_COUNT) {
        core->stack = 0;
    }
}

void left(core *core) {
    if(core->stack == 0) {
        core->stack = STACK_COUNT;
    }
    core->stack--;
}

void print_core(core *core) {
    cell iterator;
    for(iterator = 0; iterator < STACK_COUNT; iterator++) {
        if(!empty(&core->stacks[iterator])) {
            printf("%d(%d, %d): ", iterator, core->stacks[iterator].top.first, core->stacks[iterator].top.second);
            print_stack(&core->stacks[iterator]);
            if(iterator == core->stack) {
                putchar(" <");
            }
            putchar("\n");
        }
    }
}

#define BEGIN while(pop(&c.stacks[c.stack])) {
#define END   }
#define LEFT  left(&c);
#define RIGHT right(&c);
#define ZERO  push(&c.stacks[c.stack], 0);
#define ONE   push(&c.stacks[c.stack], 1);
#define HALT  return 0;
#define DEBUG print_core(&c);

static core c;
int main(void) {
    #include "program.h"
    DEBUG
    return 0;
}