/**
 * @file Nova grammar
 * @author nouveau
 */

module.exports = grammar({
  name: "nova",

  rules: {
    program: $ => repeat($.rule),

    rule: $ => seq(
      '|',
      repeat($.rule_lhs),
      '|',
      optional('\n'),
      repeat($.rule_rhs)
    ),

    rule_lhs: $ => seq(
      $.stack,
      optional($.anticonsumption_suffix),
      optional('\n')
    ),

    rule_rhs: $ => seq(
      $.stack,
      optional('\n')
    ),

    stack: $ => seq(
      $.stack_label,
      repeat(choice($.variable, $.term)),
    ),

    stack_label: $ => seq(
      ':',
      choice($.port, repeat($.label)),
      ':'
    ),

    variable: $ => seq('$', $.term),
    port: $ => seq('@', $.label),
    label: $ => /[^\n\r\t |:?@]+/,
    term: $ => /[^\n\r\t |:]+/,
    anticonsumption_suffix: $ => '?',
  }
});
