site: cmd[
    Array .new >pages
    "**/*.pstk" Directory .glob each[ 
        if[ dup .file? :then pages .push :else void ] 
    ] 
    #page: module/extend[ static/style.css: File .slurp >style ]
    source-of: fn[ .[ Path .[ "." of[ path name ] relative ] ] ]
    dest-of: fn[ .[
        Path .[ 
            "." of[ path name Path .parse .name ".html" + ] relative 
            "content/" "site/" String .replace ] ] ]
    Directory .[ 
        try[ site: rmr :catch void ]
        static: site: copy ]
    File .[ NB[ Files I don't have a better way to copy in atm ]
        "../../stvm.js" site/stvm.js: copy
        "../../stkweb.js" "site/stkweb.js" copy 
        "../../lib/browser/browser.stk" "site/browser.stk" copy
        "../../lib/core/core.stk" "site/core.stk" copy
    ]
    Set .of[ pages each[ dest-of Path .parse .dir ] ] >destFolders

    destFolders each[ Directory .ensure ]
    pages each[ >p p. dest-of p> source-of /t StackTalk .load-file ]
]

#page: module[

    "" >title
    "" >contents
    "" >imports
    "" >script
    
    @: fn[ write ]
    @title: fn[ @ title @ ]
    @style: fn[ @ style @ ]
    @contents: fn[ @ contents @ ]
    @imports: fn[ @ imports @ ]
    @script: fn[ @ script @ ]

    @header: fn[
"<!DOCTYPE html>
<html lang='en'>
<head>
    <meta charset='utf-8'>
    <meta http-equiv='X-UA-Compatile' cotent='IE=edge'/>
    <meta name='viewport' content=''/>
    <title>" @title "</title>
</head> 
" @
    ] 
    @body: fn[ 
        "<body>
            <style>
            " @style 
            "</style>
            <h2><a href='./'>" @title "</a></h2>
            <main role='main' class='conatainer'>"
                @contents
            "</main>
            "
            @imports
            "<script type='module'>"
            @script
            "</script>
        </body>" @
    ]
    render: fn[
        @header @body "</html>" @
    ]
]

#markup: module[
    nl: fn[ /nl @ ]
    
    proc-tag: fn[
        >#tag >#proc
            "<" @ #tag. @ " " @
                #proc. Proc .blocks each[ >#attr
                    #attr. @ "=\"" @
                    #proc. #attr. Proc .run? escape @
                    "\"" @
                ]
            ">" @ 

            temp[ #tag #proc done did ]
            false >done
            [ done: [ void true ] change ] >did

            #proc. proc: Proc .run? 

            if[ $: #proc. has-flag? :then $ did ]
            if[ done. ~: #proc. has-flag? or not :then @ ]

            "</" @ #tag. @ ">" @
    ]

    $: fn[ "<code>" @ escape @ "</code>" @ ]
    quot-tag: fn[ >#tag >q "<" @ #tag. @ ">" @ q> run @ "</" @ #tag> @ ">" @ ]

    tag: fn[ >#tag >#def 
        if[ #def. proc? 
            :then #def> #tag> proc-tag
            :else #def> #tag> quot-tag ] ]

    escape: fn[ "<" "&lt;" String .replace ">" "&gt;" String .replace ]

    ---: fn[ "<hr/>" @ ]
    %w[ h1 h2 h3 h4 p ul ol li code ] each[ dup fry[ _ tag ] fn ]

    br: fn[ [ :~ ] br: tag ]
    link: fn[ >q "<a href='" @ q. to: "link needs :to" Proc .run! @ "'>" @ q> proc: "link needs text!" Proc .run! @ "</a>" @ ]
    code-block: fn[ "<pre><code>" @ run @  "</code></pre>" @ ]
]

page: fn[ 
    >q w: File .open ask[ use[ #page #markup ] your[ q> ] run render close ]
]