--[[
| 
lightning struck [x] [y]
, [something] is at [x] [y]?
, [something] has inventory [inventory]?
, [inventory] has item [item]?
, [item] is [class]?
, [class] is conductive?
|
  [something] is struck by lightning

|| lightning struck 10 20,
   $enemy is at 10 20,
   $enemy has inventory $inventory,
   $inventory has item $item,
   $item is sword,
   sword is conductive
]]

local match = {
    lightning_struck_x_y = false,
    something_is_at_x_y = false,
    something_has_inventory_inventory = false,
    inventory_has_item_item = false,
    item_is_class = false,
    class_is_conductive = false,
    vars = {
    x = nil, y = nil, something = nil, inventory = nil,
    item = nil, class = nil }
}

function lightning_struck_x_y(match, patterns) 
    for x, y in patterns.lightning_struck_x_y:matches(match.x, match.y) do
        match.lightning_struck_x_y = true
        match.x = x
        match.y = y
        if match.something_is_at_x_y or something_is_at_x_y(patch, patterss) then
            return true
        end
    end
    return false
end

function something_is_at_x_y(match, patterns)
    for something, x, y in patterns.something_is_at_x_y:matches(match.someting, match.x, match.y) do
        match.something_is_at_x_y = true
        match.something = something
        match.x = x
        match.y = y
        if (match.lightning_struck_x_y or 
             lightning_struck_x_y(match, patterns))
           and (match.something_has_inventory_inventory or something_has_inventory_inventory(match, patterns)) 
           then 
            return true
        end
    end
    return false
end

function something_has_inventory_inventory(match, patterns)
    for something, inventory in patterns.something_has_inventory_inventory:matches(match.something, match.inventory) do
        match.something_has_inventory_inventory = true
        match.something = something
        match.inventory = inventory

        if (match.something_is_at_x_y or something_is_at_x_y(match, patterns))
            and (match.inventory_has_item_item or inventory_has_item_item(match, patterns))
        then
            return true
        end
    end
    return false
end

function inventory_has_item_item(match, patterns)
    for inventory, item in patterns.inventory_has_item_item:matches(match.inventory, match.item) do
        match.inventory = inventory
        match.item = item

        if (match.something_has_inventory_inventory or something_has_inventory_inventory(match, patterns))
        and (match.item_is_class or item_is_class(match, patterns)) 
        then
            return true
        end
    end
    return false
end

function item_is_class(match, patterns)
    if item, class in patterns.item_is_class:matches(match.item, match.class) do
        match.item = item
        match.class = class

        if (match.inventory_has_item_item or inventory_has_item_item(match, patterns))
        and (match.class_is_conductive or class_is_conductive(match, patterns))
        then
            return true
        end
    end
    return false
end

function class_is_conductive(match, patterns)
    for class in patterns.class_is_conductive:matches(match.class) do
        match.class = class
        if (match.item_is_class or item_is_class(match, patterns)) then
            return true
        end
    end
    return false
end

