
function copyText(text) {
    var tempInput = document.createElement("textarea");
    tempInput.style = "position: absolute; left: -1000px; top: -1000px";
    tempInput.value = text;

    document.body.appendChild(tempInput);
    tempInput.select();

    document.execCommand("copy");
    document.body.removeChild(tempInput);
}


var app = (function(){
	var exported = {};
        var stack = [];
        var env = {};
        var vals = {};

	var codeElem,
	 inputElem,
	 runCodeElem,
	 stackOutput,
	 errElem;


	exported.load = function() {
		codeElem = elmID("current-code");
		inputElem = elmID("repl");
		runCodeElem = elmID("run-code");
		stackOutput = elmID("stack-output");
		errElem = elmID("error-output");
                codeElem.value = localStorage.getItem("code") || "";
		// Clear loading indicators
		codeElem.className = "";
		runCodeElem.className = "";
		runCodeElem.value = "Run Code";


		runCodeElem.onclick = function() {
            localStorage.setItem("code", codeElem.value);
			runCode(codeElem.value);
			return false;
		};


		inputElem.onkeypress = function(event) {

			if (event.keyCode != 13 /*Enter*/) {
				return;
			}

			var code = inputElem.value;
			inputElem.value = "Executing code...";
			runCode(code);
			inputElem.value = "";

			return false;

		};

	}


	function runCode(code) {
		errElem.innerHTML = "";
		errElem.className = "hidden";
		try {
            tin_run(code, stack, env, vals);
		} catch(ex) {
		    errElem.innerHTML = ex.message;
		    errElem.className = "error";
		}
		displayStack();
	}


    function cleanStackDisplay(str) {
        return str.
            replace(/>/g, "&gt;").
            replace(/</g, "&lt;").
            replace(/\n/g, "<br/>");
    }


	function displayStack() {

		var builtHTML = "";
		for (var i = 0; i < stack.length; i++) {
		    var dropNum = i;
		    builtHTML += 
		        "<tr><td class='col'>" + cleanStackDisplay((stack[i] || "falsy").toString()) + "</td>" + 
		        "<td class='col-alt'>&lt;" + typeof(stack[i]) + "&gt;</td>" +
		    '<td class="col"><a href="javascript:app.removeStackElem(' + dropNum + ')">Remove</a></td>' +
                    '<td class="col"><a href="javascript:app.copyStackElem('+ dropNum +')">Copy</a></td>'
			    "</tr>";
		}

		stackOutput.innerHTML = builtHTML;
	}

	exported.clearStack = function() {
		stack = [];
		displayStack();
	}

    exported.copyStackElem = function(idx) {
            var valToCopy = stack[idx].toString();
            copyText(valToCopy);
    }

	exported.removeStackElem = function(idx) {
		stack.splice(idx, 1);
		displayStack();
	}

	function elmID(id) {
		return document.getElementById(id);
	}

	return exported;
})();

window.onload = app.load;
		</script>
		<script>
    function isSpace(char) { 
        return char === " " || char === "\t" || char === "\r" || char === "\n";  
    }

    function assert(condition, message) {
        if (!condition) {
            message = message || "Assertion failed";
            if (typeof Error !== "undefined") {
                throw new Error(message);
            }
            throw message;
        }
    }

    function hasSpaces(str) {
        for (var i = 0; i < str.length; i++) {
             if (isSpace(str[i])) {
                 return true;
             }
        }
        return false;
    }

    function list_of_string(code) {
         var next = tokenize(code);
         var list = [];
         var tok = next();
         while (! tok.message) {
             list.push(tok);
             tok = next();
         }
         assert(tok.message === "EOF", tok);
         return list;
    }


function tokenize(code) {
   if (Array.isArray(code)) {
       var i = 0;

       return function (msg) {
           if (i >= code.length) { return { message: msg || "EOF" }; }
           var retVal = code[i];
           i++;
           return retVal;
       }
   }

   if (code.message) {
       throw code;
   }

   assert(typeof(code) === "string", "Can only tokenize a string or an array!"); 

   // Current token
   var tok = "";

   // Build up current token until we hit a space, a [ or a "
   var idx = 0;
   function eatSpace() {
       if (idx >= code.length) {
           return;
       }

       while (isSpace(code[idx])) {
           if (idx >= code.length) { return; }
           idx++;
       }
   }

   // next token
   return function(msg) {
      // Eat spaces
      eatSpace();

      if (idx >= code.length) { return { message: msg || "EOF" }; }

      var char = code[idx];

      if (char === "[") {
          var seekIdx = idx;
          var depth = 1;
          while(depth > 0) {
              seekIdx++;
              if (seekIdx >= code.length) { throw "Unexpected EOF!"; }
              if (code[seekIdx] === "[") { depth++; }
              if (code[seekIdx] === "]") { depth--; }
              if (depth < 0) { 
                   throw "Unexpected ]"; 
              }
          }
          var retVal = code.slice(idx + 1, seekIdx);
          idx = seekIdx + 1;
          return retVal;
      }

      if (char === "\"") {

          var seekIdx = idx + 1;
          while(code[seekIdx] != "\"") { 
              seekIdx++;
              if (seekIdx >= code.length) {
                   throw "Unterminated string!";
              }
          }

          var retVal = code.slice(idx + 1, seekIdx);
          idx = seekIdx + 1;
          return retVal;
      }

      var seekIdx = idx + 1;

      while(!isSpace(code[seekIdx])) {
          seekIdx++;
          if (seekIdx >= code.length) {
              var retVal = code.slice(idx, seekIdx);
              idx = seekIdx;
              return retVal;
          }
      }

      var retVal = code.slice(idx, seekIdx);
      idx = seekIdx + 1;
      return retVal;
   }
}


function pop(stack) {
    if (stack.length === 0) { throw { message: "Data underflow" } }
    return stack.pop();
}

function eval_or_push(tok, env, stack, next, vals) {
    if (typeof(env[tok]) === "function") { env[tok](next, vals); }
    else { stack.push(tok); } 
}


function tin_run(code, stack, env, vals) {
    var env = env || {};
    var next = tokenize(code);
    var stack = stack || [];
    var vals = vals || {};

    function num_op(fn) {
        var a = pop(stack);
        var b = pop(stack);
        stack.push(fn(Number(b), Number(a)));
    }


    env["+"] = env["+"] || function() {
        num_op(function(a,b) {return a + b});
    };

    env["*"] = env["*"] || function() {
        num_op(function(a,b) {return a * b});
    };

    env["/"] = env["/"] || function() {
        num_op(function(a,b) {return a / b});
    };

    env["-"] = env["-"] || function() {
        num_op(function(a,b) { return a - b}); 
    };

    env["concat"] = env["concat"] || function() {
         var b = pop(stack).toString();
         var a = pop(stack).toString();

         stack.push(a + b);
    }

    env["rand"] = env["rand"] || function() {
       var max = Number(pop(stack));
       // Based on https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/random
       stack.push(Math.floor(Math.random() * Math.floor(max)));
    };

    env["str:"] = env["str:"] || function(next, vals) {
       var str = next("str: expected a string literal");
       stack.push(str);
    };

    env["split"] = env["split"] || function(next, vals) {
       var sep = pop(stack);
       var str = pop(stack);
       stack.push(str.toString().split(sep));
    }; 

    env["eval"] = env["eval"] || function(next, vals) {
        var fragment = pop(stack);
        tin_exec(tokenize(fragment), stack, env, vals); 
    };

    env["dup"] = env["dup"] || function() { stack.push(stack[stack.length - 1]); };

    env["swap"] = env["swap"] || function() { 
        var b = pop(stack);
        var a = pop(stack);

        stack.push(b);
        stack.push(a);
    }

    env["drop"] = env["drop"] || function() { pop(stack); };
    env["print"] = env["print"] || function() { console.log(pop(stack)); };
    env["vec"] = env["vec"] || function(next, vals) {
        var literal = pop(stack);
        assert(literal, "No data on stack");
        stack.push(tin_exec(tokenize(literal), [], env, vals)); 

    };

    env["set"] = function() {
        var name = pop(stack).toString();
        var value = pop(stack);
        vals[name] = value;
    };

    env["get"] = function() {
       var name = pop(stack).toString();
       stack.push(vals[name]);
    }

    env["t"] = function() { stack.push(true); };
    env["f"] = function() { stack.push(false); };

    env["and"] = function() { 
        var b = pop(stack);
        var a = pop(stack);
        stack.push(a && b);
    }

    env["or"] = function() {
        var b = pop(stack);
        var a = pop(stack); 
        stack.push(a || b); 
    }

    function timeFromString(time_str) {
       var parser = /(\d+):(\d+)(a|p|am|pm)/i;
       var parts = parser.exec(time_str);
       var hour = Number.parseFloat(parts[1], 10);
       var minutes = Number.parseFloat(parts[2], 10);

       if (hour < 12 && (parts[3] === "p" || parts[3] === "pm")) {
            hour += 12;
       }

       return new Date(2019,1,1, hour, minutes);
    }

    env["duration"] = function() {

       var b = pop(stack);
       var a = pop(stack);
       var a_time = timeFromString(a);
       var b_time = timeFromString(b);

       stack.push((b_time.getHours() + (b_time.getMinutes() / 60) ) - (a_time.getHours() + a_time.getMinutes() / 60)); 

    }

    env["not"] = function() { stack.push(!pop(stack)); }

    env["when:"] = function(next, vals) {
        var cond = pop(stack);
        if (cond) {
            tin_exec(tokenize(next("when: expected a string")), stack, env, vals);

        }

    };

    env["if:"] = function(next, vals) {
        var cond = pop(stack);
        var t_branch = list_of_string(next("if: expected a true branch"));
        var f_branch = list_of_string(next("if: expected a false branch"));

        if (cond) {
            tin_exec(tokenize(t_branch), stack, env, vals);
        } else {
            tin_exec(tokenize(f_branch), stack, env, vals);
        }
    };

    /*
    env["while-do"] = env["while-do"] || function(next, vals) {
       var cond = list_of_string(pop(stack));
       var body = list_of_string(next("while-do: expects a body"));
       var toCheck = tin_exec(tokenize(cond), stack, env, vals);
       while(toCheck[0]) {
           tin_exec(tokenize(body), stack, env, vals);
           toCheck = tin_exec(tokenize(cond), stack, env, vals);
       }
    }*/ 

    env["times:"] = env["times:"] || function(next, vals) {
        // debugger;
        var num_times = Number(pop(stack));
        var body = list_of_string(next("times: expects an expression to repeat"));
        for (var i = 0; i < num_times; i++) {
            tin_exec(tokenize(body), stack, env, vals);
        }    
    }

    env["def:"] = env["def:"] || function(next, vals) {

         // A spec is a name and a list of arguments
         var spec = list_of_string(next("def: expects a function specification"));
         assert(spec.length > 0, "The spec for a function *must* have a name!");
         var name = spec[0];

         var def = list_of_string(next("def: expects a function body"));
         env[name] = function(next, vals) {
             var old_vals = vals;
             vals = {};
             tin_exec(tokenize(def), stack, env, vals);
             vals = old_vals;
         }
    };
    tin_exec(next, stack, env, vals);

}



function tin_exec(next, stack, env, vals) {
    stack = stack || [];
    vals = vals || {};

    var tok = next();

    while (!tok.message) {
        eval_or_push(tok, env, stack, next, vals);
        tok = next();
    }
    return stack;
}
