title[ StackTalk ]

"Stack Basics" note[

    An object is a collection of named stacks
    A quotation is a malleable list of code symbols, delimited by [ and ]
    Strings can be written two ways:

    "This is a conventional string"
    this-is-a-symbol-string: 
    
    There are 4 baseline stack operations:

    `$value $stack push`
    `$stack pop`
    `$stack peek`
    `$stack run`

    These let you manipulate arbitrarily named stacks.
    `run` is a bit special. It'll run top of $stack, if it is a 
    quotation, otherwise it acts like peek 

    There are shortcuts for these operations:

    [ 1 x: push ]  can be writtn as [ 1 >x ]
    [ x: peek ] can be written as [ x. ] when you need no ambiguity
    [ x: pop ] can be written as [ x> ]
    [ x: run ] can be written as [ x ]

] 

"Quotation suffix autoswap" note[
    This one is a little inspired by https://knucklecracker.com/wiki/doku.php?id=crpl:overview#warp_notation, 
    but is ultimately a bit less generalized.

    I anticipate that quotations will be modified by a lot of words. Because of this, and because
    I think it reads better in a lot of cases, there's another rewrite

    [ 1 [ me> 1 + >me ] do ] can be written as [ 1 do[ me> 1 + >me ] ]

    This is how `note` has been working.
]


Objects: note[

    The current Object/scope is the top of the `me:` stack.


    `do` executes the quotation inside the scope of object below
    it in the stack.

    `$subject $quotation do`

    Shorthand
    [ AnObject [ aThing ] do ] can be written as [ AnObject .aThing ]

]

Experimental: note[
    Some code snippets that I'm noodling on.

    experimental[
        1 >x 2 >y 3 >z
        [ x: y: z: ] from-stacks
    ]
]
