Conf: <-[ secrets.json: File .slurp JSON .parse do[
    api-key: fn[ get[ Trello: APIKey: ] ]
    api-token: fn[ get[ Trello: APIToken: ] ]

    auth-kv: fn[ key: api-key token: api-token ]

    main-board: fn[ get[ Boards: main: ] ]
    archive-board: fn[ get[ Boards: archive: ] ]

    day-list-template: fn[ get[ Lists: day-list-template: ] ]

  ]
]

TrelloEndpoints: is-obj[
  API-BASE: <-[ "https://api.trello.com/1" ]
  get-lists-on-board: fn[ let[ id ] 
    URL .of[ 
      API-BASE /boards/: id /lists/:
      ?[ Conf .auth-kv ]
    ]
  ]

  new-list: fn[ let[ name onBoard ] 
    URL .of[ 
      API-BASE /lists/:
      ?[ Conf .auth-kv name: name idBoard: onBoard ] ]
  ]
  new-list-at: fn[ let[ name pos onBoard ]
    URL .of[ 
      API-BASE /lists/:
      ?[ Conf .auth-kv 
        name: name idBoard: onBoard pos: pos ] 
    ]
  ]
  list-from-template-at: fn[ let[ name pos onBoard templateId ] 
    URL .of[ 
      API-BASE /lists/:
      ?[ Conf .auth-kv 
        name: name idBoard: onBoard 
        pos: pos idListSource: templateId ] 
    ]
  ]

  move-list-to-board: fn[ let[ listId toBoard ]
    URL .of[
      API-BASE /lists/: listId /idBoard: 
      ?[ value: toBoard Conf .auth-kv ] ] 
  ] 
]

trello-list: module[ use[ simple-wrapper ] temp[ gets props ]
  props[ id name closed color idBoard pos subscribed ] ]

Trello: is-obj[
  get-lists-on-board: fn[ NB[ board-id ]
      TrelloEndpoints .get-lists-on-board 
      HTTP .get .json .value 
      Array .from-raw .map[ cell do[ use[ trello-list ] ] ] 
  ]

  move-list-to-board: fn[ NB[ listId toBoard ]
    TrelloEndpoints .move-list-to-board "" HTTP .put .utf8 /l
  ]
  list-from-template-at: fn[ NB[ name pos onBoard templateId ] 
    TrelloEndpoints .list-from-template-at "" HTTP .post .utf8 /l
  ]

  archive-list: fn[ Conf .archive-board move-list-to-board ]
]


test: fn[ 
  Conf .main-board Trello .get-lists-on-board .filter[ 
    .name String .[ "*" contains? ] NB true
  ] in-each[ name /l pos /l ]
]

cleanup: fn[
  Conf .main-board Trello .get-lists-on-board .filter[ 
    .name String .[ "*" contains? ] 
  ] each[ .id Trello .archive-list ]
]

setup: fn[ 
  "Needs to be updated before running again!" error
  /#[ 
    "Friday 2/20" 
    "Thursday 2/19" 
    "Wednesday 2/18" 
    "Tuesday 2/17" 
    "Monday 2/16" 
  ] each[ 
    6 Conf .[ main-board day-list-template ] Trello .list-from-template-at
  ]
]
